/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.network;

import dev.emi.emi.chess.EmiChess;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class EmiChessPacket
implements EmiPacket {
    protected final UUID uuid;
    protected final byte type;
    protected final byte start;
    protected final byte end;

    public EmiChessPacket(UUID uuid, byte type, byte start, byte end) {
        this.uuid = uuid;
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public EmiChessPacket(FriendlyByteBuf buf) {
        this(buf.readUUID(), buf.readByte(), buf.readByte(), buf.readByte());
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
        buf.writeByte((int)this.type);
        buf.writeByte((int)this.start);
        buf.writeByte((int)this.end);
    }

    @Override
    public ResourceLocation getId() {
        return EmiNetwork.CHESS;
    }

    public static class C2S
    extends EmiChessPacket {
        public C2S(UUID uuid, byte type, byte start, byte end) {
            super(uuid, type, start, end);
        }

        public C2S(FriendlyByteBuf buf) {
            super(buf);
        }

        @Override
        public void apply(Player player) {
            Player opponent = player.level().getPlayerByUUID(this.uuid);
            if (opponent instanceof ServerPlayer) {
                ServerPlayer spe = (ServerPlayer)opponent;
                EmiNetwork.sendToClient(spe, new S2C(player.getUUID(), this.type, this.start, this.end));
            }
        }
    }

    public static class S2C
    extends EmiChessPacket {
        public S2C(UUID uuid, byte type, byte start, byte end) {
            super(uuid, type, start, end);
        }

        public S2C(FriendlyByteBuf buf) {
            super(buf);
        }

        @Override
        public void apply(Player player) {
            EmiChess.receiveNetwork(this.uuid, this.type, this.start, this.end);
        }
    }
}

