/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.platform.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.PingS2CPacket;
import dev.emi.emi.platform.EmiMain;
import dev.emi.emi.platform.neoforge.EmiPacketHandler;
import dev.emi.emi.registry.EmiCommands;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="emi")
public class EmiNeoForge {
    public EmiNeoForge(IEventBus modEventBus) {
        EmiMain.init();
        modEventBus.addListener(EmiPacketHandler::init);
        EmiNetwork.initServer((player, packet) -> PacketDistributor.PLAYER.with(player).send(new CustomPacketPayload[]{EmiPacketHandler.wrap(packet)}));
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::playerConnect);
    }

    public void registerCommands(RegisterCommandsEvent event) {
        EmiCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer spe = (ServerPlayer)player;
            EmiNetwork.sendToClient(spe, new PingS2CPacket());
        }
    }
}

