/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.platform.neoforge;

import dev.emi.emi.network.CommandS2CPacket;
import dev.emi.emi.network.CreateItemC2SPacket;
import dev.emi.emi.network.EmiChessPacket;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.network.FillRecipeC2SPacket;
import dev.emi.emi.network.PingS2CPacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class EmiPacketHandler {
    private static final ResourceLocation ID_CHESS_CLIENTBOUND = new ResourceLocation("emi", "chess_s2c");
    private static final ResourceLocation ID_CHESS_SERVERBOUND = new ResourceLocation("emi", "chess_c2s");

    public static void init(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("emi").optional();
        registrar.play(EmiNetwork.FILL_RECIPE, EmiPacketHandler.makeReader(EmiNetwork.FILL_RECIPE, FillRecipeC2SPacket::new), EmiPacketHandler::handleServerbound);
        registrar.play(EmiNetwork.CREATE_ITEM, EmiPacketHandler.makeReader(EmiNetwork.CREATE_ITEM, CreateItemC2SPacket::new), EmiPacketHandler::handleServerbound);
        registrar.play(EmiNetwork.PING, EmiPacketHandler.makeReader(EmiNetwork.PING, PingS2CPacket::new), EmiPacketHandler::handleClientbound);
        registrar.play(EmiNetwork.COMMAND, EmiPacketHandler.makeReader(EmiNetwork.COMMAND, CommandS2CPacket::new), EmiPacketHandler::handleClientbound);
        registrar.play(ID_CHESS_SERVERBOUND, EmiPacketHandler.makeReader(ID_CHESS_SERVERBOUND, EmiChessPacket.C2S::new), EmiPacketHandler::handleServerbound);
        registrar.play(ID_CHESS_CLIENTBOUND, EmiPacketHandler.makeReader(ID_CHESS_CLIENTBOUND, EmiChessPacket.S2C::new), EmiPacketHandler::handleClientbound);
    }

    public static CustomPacketPayload wrap(EmiPacket packet) {
        if (packet instanceof EmiChessPacket.S2C) {
            return new PayloadWrapper<EmiPacket>(ID_CHESS_CLIENTBOUND, packet);
        }
        if (packet instanceof EmiChessPacket.C2S) {
            return new PayloadWrapper<EmiPacket>(ID_CHESS_SERVERBOUND, packet);
        }
        return new PayloadWrapper<EmiPacket>(packet.getId(), packet);
    }

    private static <T extends EmiPacket> FriendlyByteBuf.Reader<PayloadWrapper<T>> makeReader(ResourceLocation id, Function<FriendlyByteBuf, T> reader) {
        return buffer -> new PayloadWrapper<EmiPacket>(id, (EmiPacket)reader.apply((FriendlyByteBuf)buffer));
    }

    private static void handleServerbound(PayloadWrapper<?> wrapper, PlayPayloadContext context) {
        Object packet = wrapper.packet();
        if (!context.flow().isServerbound()) {
            throw new IllegalArgumentException("Trying to handle serverbound packet on client: " + String.valueOf(packet));
        }
        Player player = context.player().orElse(null);
        context.workHandler().execute(() -> packet.apply(player));
    }

    private static void handleClientbound(PayloadWrapper<?> wrapper, PlayPayloadContext context) {
        Object packet = wrapper.packet();
        if (!context.flow().isClientbound()) {
            throw new IllegalArgumentException("Trying to handle clientbound packet on server: " + String.valueOf(packet));
        }
        Player player = context.player().orElse(null);
        context.workHandler().execute(() -> packet.apply(player));
    }

    private record PayloadWrapper<T extends EmiPacket>(ResourceLocation id, T packet) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buf) {
            this.packet.write(buf);
        }
    }
}

