/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class EmiShapedRecipe
extends EmiCraftingRecipe {
    public EmiShapedRecipe(ShapedRecipe recipe) {
        super(EmiShapedRecipe.padIngredients(recipe), EmiStack.of(EmiPort.getOutput(recipe)), EmiPort.getId(recipe), false);
        EmiShapedRecipe.setRemainders(this.input, (CraftingRecipe)recipe);
    }

    public static void setRemainders(List<EmiIngredient> input, CraftingRecipe recipe) {
        try {
            TransientCraftingContainer inv = EmiUtil.getCraftingInventory();
            for (int i = 0; i < input.size(); ++i) {
                if (input.get(i).isEmpty()) continue;
                for (int j = 0; j < input.size(); ++j) {
                    if (j == i || input.get(j).isEmpty()) continue;
                    inv.setItem(j, input.get(j).getEmiStacks().get(0).getItemStack().copy());
                }
                List<EmiStack> stacks = input.get(i).getEmiStacks();
                for (EmiStack stack : stacks) {
                    inv.setItem(i, stack.getItemStack().copy());
                    ItemStack remainder = (ItemStack)recipe.getRemainingItems((Container)inv).get(i);
                    if (remainder.isEmpty()) continue;
                    stack.setRemainder(EmiStack.of(remainder));
                }
                inv.clearContent();
            }
        }
        catch (Exception e) {
            EmiLog.error("Exception thrown setting remainders for " + String.valueOf(EmiPort.getId(recipe)), e);
        }
    }

    private static List<EmiIngredient> padIngredients(ShapedRecipe recipe) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (x >= recipe.getWidth() || y >= recipe.getHeight() || i >= recipe.getIngredients().size()) {
                    list.add(EmiStack.EMPTY);
                    continue;
                }
                list.add(EmiIngredient.of((Ingredient)recipe.getIngredients().get(i++)));
            }
        }
        return list;
    }
}

