/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EmiBannerShieldRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> BANNERS = List.of(Items.WHITE_BANNER, Items.ORANGE_BANNER, Items.MAGENTA_BANNER, Items.LIGHT_BLUE_BANNER, Items.YELLOW_BANNER, Items.LIME_BANNER, Items.PINK_BANNER, Items.GRAY_BANNER, Items.LIGHT_GRAY_BANNER, Items.CYAN_BANNER, Items.PURPLE_BANNER, Items.BLUE_BANNER, Items.BROWN_BANNER, Items.GREEN_BANNER, Items.RED_BANNER, Items.BLACK_BANNER);
    private static final List<EmiStack> EMI_BANNERS = BANNERS.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList());
    public static final EmiStack SHIELD = EmiStack.of((ItemLike)Items.SHIELD);

    public EmiBannerShieldRecipe(ResourceLocation id) {
        super(Stream.concat(Stream.of(SHIELD), EMI_BANNERS.stream()).toList(), EmiStack.of((ItemLike)Items.SHIELD), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(SHIELD, x, y);
        }
        if (slot == 1) {
            return new GeneratedSlotWidget(r -> this.getPattern((Random)r, null), this.unique, x, y);
        }
        return new SlotWidget(EmiStack.EMPTY, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getPattern((Random)r, Items.SHIELD), this.unique, x, y);
    }

    public EmiStack getPattern(Random random, Item item) {
        int base = random.nextInt(BANNERS.size());
        if (item == null) {
            item = BANNERS.get(base);
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        int patterns = 1 + Math.max(random.nextInt(5), random.nextInt(3));
        BannerPattern.Builder pattern = new BannerPattern.Builder();
        for (int i = 0; i < patterns; ++i) {
            pattern = EmiPort.addRandomBanner(pattern, random);
        }
        CompoundTag tag = new CompoundTag();
        tag.put("Patterns", (Tag)pattern.toListTag());
        if (item == Items.SHIELD) {
            tag.putInt("Base", ((BannerItem)BANNERS.get(base)).getColor().getId());
        }
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)BlockEntityType.BANNER, (CompoundTag)tag);
        return EmiStack.of(stack);
    }
}

