/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EmiFireworkStarRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).toList();
    private static final List<Item> SHAPES = List.of(Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD);
    private static final List<Item> EFFECTS = List.of(Items.DIAMOND, Items.GLOWSTONE_DUST);

    public EmiFireworkStarRecipe(ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiIngredient.of(SHAPES.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiIngredient.of(EFFECTS.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiStack.of((ItemLike)Items.GUNPOWDER)), EmiStack.of((ItemLike)Items.FIREWORK_STAR), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.GUNPOWDER), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<Item> items = this.getItems((Random)r);
            if (s < items.size()) {
                return EmiStack.of((ItemLike)items.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkStar, this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private List<Item> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(4);
        if (amount < 2) {
            items.add(EFFECTS.get(amount));
        } else if (amount == 2) {
            items.add(EFFECTS.get(0));
            items.add(EFFECTS.get(1));
        }
        amount = random.nextInt(10);
        if (amount < 9) {
            items.add(SHAPES.get(amount));
        }
        items.addAll(this.getDyes(random, 8 - items.size()));
        return items;
    }

    private EmiStack getFireworkStar(Random random) {
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        CompoundTag tag = new CompoundTag();
        CompoundTag explosion = new CompoundTag();
        boolean hasShape = false;
        List<Item> items = this.getItems(random);
        byte smallBall = 0;
        byte largeBall = 1;
        byte star = 2;
        byte creeper = 3;
        byte burst = 4;
        ArrayList colors = Lists.newArrayList();
        for (Item item : items) {
            if (Items.GLOWSTONE_DUST.equals(item)) {
                explosion.putByte("Flicker", largeBall);
                continue;
            }
            if (Items.DIAMOND.equals(item)) {
                explosion.putByte("Trail", largeBall);
                continue;
            }
            if (Items.FIRE_CHARGE.equals(item)) {
                explosion.putByte("Type", largeBall);
                hasShape = true;
                continue;
            }
            if (Items.GOLD_NUGGET.equals(item)) {
                explosion.putByte("Type", star);
                hasShape = true;
                continue;
            }
            if (Items.FEATHER.equals(item)) {
                explosion.putByte("Type", burst);
                hasShape = true;
                continue;
            }
            if (SHAPES.contains(item)) {
                explosion.putByte("Type", creeper);
                hasShape = true;
                continue;
            }
            DyeItem dyeItem = (DyeItem)item;
            colors.add(dyeItem.getDyeColor().getFireworkColor());
        }
        if (!hasShape) {
            explosion.putByte("Type", smallBall);
        }
        explosion.putIntArray("Colors", (List)colors);
        tag.put("Explosion", (Tag)explosion);
        stack.setTag(tag);
        return EmiStack.of(stack);
    }
}

