/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;

public class EmiSuspiciousStewRecipe
extends EmiPatternCraftingRecipe {
    private static final List<Item> FLOWERS = EmiPort.getItemRegistry().stream().filter(i -> {
        BlockItem bi;
        return i instanceof BlockItem && (bi = (BlockItem)i).getBlock() instanceof FlowerBlock;
    }).collect(Collectors.toList());

    public EmiSuspiciousStewRecipe(ResourceLocation id) {
        super(List.of(EmiStack.of((ItemLike)Items.BOWL), EmiStack.of((ItemLike)Items.RED_MUSHROOM), EmiStack.of((ItemLike)Items.BROWN_MUSHROOM), EmiIngredient.of(FLOWERS.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList()))), EmiStack.of((ItemLike)Items.SUSPICIOUS_STEW), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.BOWL), x, y);
        }
        if (slot == 1) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.RED_MUSHROOM), x, y);
        }
        if (slot == 2) {
            return new SlotWidget(EmiStack.of((ItemLike)Items.BROWN_MUSHROOM), x, y);
        }
        if (slot == 3) {
            return new GeneratedSlotWidget(r -> EmiStack.of((ItemLike)this.getFlower((Random)r)), this.unique, x, y);
        }
        return new SlotWidget(EmiStack.EMPTY, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> {
            FlowerBlock block = (FlowerBlock)((BlockItem)this.getFlower((Random)r)).getBlock();
            ItemStack stack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
            SuspiciousStewItem.appendMobEffects((ItemStack)stack, (List)block.getSuspiciousEffects());
            return EmiStack.of(stack);
        }, this.unique, x, y);
    }

    private Item getFlower(Random random) {
        return FLOWERS.get(random.nextInt(FLOWERS.size()));
    }
}

