/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.util.InheritanceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class EmiTags {
    public static final InheritanceMap<EmiRegistryAdapter<?>> ADAPTERS_BY_CLASS = new InheritanceMap(Maps.newHashMap());
    public static final Map<Registry<?>, EmiRegistryAdapter<?>> ADAPTERS_BY_REGISTRY = Maps.newHashMap();
    public static final ResourceLocation HIDDEN_FROM_RECIPE_VIEWERS = EmiPort.id("c", "hidden_from_recipe_viewers");
    private static final Map<TagKey<?>, ResourceLocation> MODELED_TAGS = Maps.newHashMap();
    private static final Map<Set<?>, List<TagKey<?>>> CACHED_TAGS = Maps.newHashMap();
    private static final Map<TagKey<?>, List<?>> TAG_CONTENTS = Maps.newHashMap();
    private static final Map<TagKey<?>, List<?>> TAG_VALUES = Maps.newHashMap();
    private static final Map<ResourceLocation, List<TagKey<?>>> SORTED_TAGS = Maps.newHashMap();
    public static final List<TagKey<?>> TAGS = Lists.newArrayList();
    public static TagExclusions exclusions = new TagExclusions();

    public static <T> Registry<T> getRegistry(TagKey<T> key) {
        Minecraft client = Minecraft.getInstance();
        return client.level.registryAccess().registry(key.registry()).orElse(null);
    }

    public static <T> List<EmiStack> getValues(TagKey<T> key) {
        EmiRegistryAdapter<?> adapter;
        if (TAG_VALUES.containsKey(key) && (adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key))) != null) {
            List values = TAG_VALUES.getOrDefault(key, List.of());
            return values.stream().map(t -> adapter.of(t, EmiPort.emptyExtraData(), 1L)).toList();
        }
        return List.of();
    }

    public static <T> List<EmiStack> getRawValues(TagKey<T> key) {
        if (key.registry().equals(EmiPort.getBlockRegistry().key())) {
            return EmiUtil.values(key).map(e -> EmiStack.of((ItemLike)((Block)e.value()))).toList();
        }
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key));
        if (adapter != null) {
            List<Object> values = EmiUtil.values(key).map(Holder::value).toList();
            return values.stream().map(t -> adapter.of(t, EmiPort.emptyExtraData(), 1L)).toList();
        }
        return List.of();
    }

    public static <T> EmiIngredient getIngredient(Class<T> clazz, List<EmiStack> stacks, long amount) {
        HashMap map = Maps.newHashMap();
        for (EmiStack stack : stacks) {
            if (stack.isEmpty()) continue;
            EmiStack existing = map.getOrDefault(stack.getKey(), null);
            if (existing != null && !stack.equals(existing)) {
                return new ListEmiIngredient(stacks, amount);
            }
            map.put(stack.getKey(), stack);
        }
        if (map.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (map.size() == 1) {
            return ((EmiStack)map.values().stream().toList().get(0)).copy().setAmount(amount);
        }
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_CLASS.get(clazz);
        if (adapter == null) {
            return new ListEmiIngredient(stacks, amount);
        }
        Registry<?> registry = adapter.getRegistry();
        ArrayList keys = CACHED_TAGS.get(map.keySet());
        if (keys != null) {
            for (TagKey<?> key : keys) {
                List<?> values = TAG_CONTENTS.get(key);
                values.forEach(map::remove);
            }
        } else {
            keys = Lists.newArrayList();
            HashSet original = new HashSet(map.keySet());
            for (TagKey<?> key : EmiTags.getTags(registry)) {
                List<?> values = TAG_CONTENTS.get(key);
                if (values.size() < 2) continue;
                if (map.keySet().containsAll(values)) {
                    values.forEach(map::remove);
                    keys.add(key);
                }
                if (!map.isEmpty()) continue;
                break;
            }
            CACHED_TAGS.put(original, keys);
        }
        if (keys == null || keys.isEmpty()) {
            return new ListEmiIngredient(stacks.stream().toList(), amount);
        }
        if (map.isEmpty()) {
            if (keys.size() == 1) {
                return EmiTags.tagIngredient((TagKey)keys.get(0), amount);
            }
            return new ListEmiIngredient(keys.stream().map(k -> EmiTags.tagIngredient(k, 1L)).toList(), amount);
        }
        return new ListEmiIngredient(List.of(map.values().stream().map(i -> i.copy().setAmount(1L)).toList(), keys.stream().map(k -> EmiTags.tagIngredient(k, 1L)).toList()).stream().flatMap(a -> a.stream()).toList(), amount);
    }

    private static EmiIngredient tagIngredient(TagKey<?> key, long amount) {
        List<?> list = TAG_VALUES.get(key);
        if (list == null || list.isEmpty()) {
            return EmiStack.EMPTY;
        }
        if (list.size() == 1) {
            return new TagEmiIngredient(key, amount).getEmiStacks().get(0).copy().setAmount(amount);
        }
        return new TagEmiIngredient(key, amount);
    }

    public static <T> List<TagKey<T>> getTags(Registry<T> registry) {
        return SORTED_TAGS.getOrDefault(registry.key().location(), List.of());
    }

    public static Component getTagName(TagKey<?> key) {
        String s = EmiTags.getTagTranslationKey(key);
        if (s == null) {
            return EmiPort.literal("#" + String.valueOf(key.location()));
        }
        return EmiPort.translatable(s);
    }

    public static boolean hasTranslation(TagKey<?> key) {
        return EmiTags.getTagTranslationKey(key) != null;
    }

    @Nullable
    private static String getTagTranslationKey(TagKey<?> key) {
        ResourceLocation registry = key.registry().location();
        if (registry.getNamespace().equals("minecraft")) {
            String s = EmiTags.translatePrefix("tag." + registry.getPath().replace("/", ".") + ".", key.location());
            if (s != null) {
                return s;
            }
        } else {
            String s = EmiTags.translatePrefix("tag." + registry.getNamespace() + "." + registry.getPath().replace("/", ".") + ".", key.location());
            if (s != null) {
                return s;
            }
        }
        return EmiTags.translatePrefix("tag.", key.location());
    }

    @Nullable
    private static String translatePrefix(String prefix, ResourceLocation id) {
        String s = EmiUtil.translateId(prefix, id);
        if (I18n.exists((String)s)) {
            return s;
        }
        if (id.getNamespace().equals("forge") && I18n.exists((String)(s = EmiUtil.translateId(prefix, EmiPort.id("c", id.getPath()))))) {
            return s;
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getCustomModel(TagKey<?> key) {
        ResourceLocation rid = key.location();
        if (rid.getNamespace().equals("forge") && !MODELED_TAGS.containsKey(key)) {
            key = TagKey.create((ResourceKey)key.registry(), (ResourceLocation)EmiPort.id("c", rid.getPath()));
        }
        return MODELED_TAGS.get(key);
    }

    public static boolean hasCustomModel(TagKey<?> key) {
        return EmiTags.getCustomModel(key) != null;
    }

    public static void registerTagModels(ResourceManager manager, Consumer<ResourceLocation> consumer) {
        String[] parts;
        String path;
        MODELED_TAGS.clear();
        for (ResourceLocation id : EmiPort.findResources(manager, "models/tag", s -> s.endsWith(".json"))) {
            path = id.getPath();
            parts = (path = path.substring(11, path.length() - 5)).split("/");
            if (parts.length <= 1) continue;
            TagKey key = TagKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)EmiPort.id("minecraft", parts[0])), (ResourceLocation)EmiPort.id(id.getNamespace(), path.substring(1 + parts[0].length())));
            ResourceLocation mid = EmiPort.id(id.getNamespace(), "tag/" + path);
            MODELED_TAGS.put(key, mid);
            consumer.accept(mid);
        }
        for (ResourceLocation id : EmiPort.findResources(manager, "models/item/tags", s -> s.endsWith(".json"))) {
            path = id.getPath();
            path = path.substring(0, path.length() - 5);
            parts = path.substring(17).split("/");
            if (!id.getNamespace().equals("emi") || parts.length <= 1) continue;
            ModelResourceLocation mid = new ModelResourceLocation(id.getNamespace(), path.substring(12), "inventory");
            MODELED_TAGS.put(TagKey.create((ResourceKey)EmiPort.getItemRegistry().key(), (ResourceLocation)EmiPort.id(parts[0], path.substring(18 + parts[0].length()))), (ResourceLocation)mid);
            consumer.accept((ResourceLocation)mid);
        }
    }

    public static void reload() {
        TAGS.clear();
        SORTED_TAGS.clear();
        TAG_CONTENTS.clear();
        TAG_VALUES.clear();
        CACHED_TAGS.clear();
        for (Registry<?> registry : ADAPTERS_BY_REGISTRY.keySet()) {
            EmiTags.reloadTags(registry);
        }
    }

    private static <T> void reloadTags(Registry<T> registry) {
        Set hidden = EmiUtil.values(TagKey.create((ResourceKey)registry.key(), (ResourceLocation)HIDDEN_FROM_RECIPE_VIEWERS)).map(Holder::value).collect(Collectors.toSet());
        ResourceLocation rid = registry.key().location();
        List<Object> tags = registry.getTagNames().filter(key -> !exclusions.contains(rid, key.location()) && !hidden.containsAll(EmiUtil.values(key).map(Holder::value).toList())).toList();
        EmiTags.logUntranslatedTags(tags);
        tags = EmiTags.consolodateTags(tags);
        for (TagKey key2 : tags) {
            List<Object> contents = EmiUtil.values(key2).map(i -> i.value()).toList();
            TAG_CONTENTS.put(key2, contents);
            List<Object> values = contents.stream().filter(s -> !EmiHidden.isDisabled(EmiTags.stackFromKey(key2, s))).toList();
            if (values.isEmpty()) {
                TAG_VALUES.put(key2, contents);
                continue;
            }
            TAG_VALUES.put(key2, values);
        }
        TAGS.addAll(tags.stream().sorted((a, b) -> a.toString().compareTo(b.toString())).toList());
        tags = tags.stream().sorted((a, b) -> Long.compare(EmiUtil.values(b).count(), EmiUtil.values(a).count())).toList();
        SORTED_TAGS.put(registry.key().location(), tags);
    }

    private static <T> EmiStack stackFromKey(TagKey<T> key, T t) {
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key));
        if (adapter != null) {
            return adapter.of(t, EmiPort.emptyExtraData(), 1L);
        }
        throw new UnsupportedOperationException("Unsupported tag registry " + String.valueOf(key));
    }

    private static <T> void logUntranslatedTags(List<TagKey<T>> tags) {
        if (EmiConfig.logUntranslatedTags) {
            ArrayList untranslated = Lists.newArrayList();
            for (Object tag : tags) {
                if (EmiTags.hasTranslation(tag)) continue;
                untranslated.add(tag.location().toString());
            }
            if (!untranslated.isEmpty()) {
                for (Object tag : untranslated.stream().sorted().toList()) {
                    EmiReloadLog.warn("Untranslated tag #" + tag);
                }
                EmiReloadLog.info(" Tag warning can be disabled in the config, EMI docs describe how to add a translation or exclude tags.");
            }
        }
    }

    private static <T> List<TagKey<T>> consolodateTags(List<TagKey<T>> tags) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tags.size(); ++i) {
            TagKey<T> key = tags.get(i);
            Set values = EmiUtil.values(key).map(Holder::value).collect(Collectors.toSet());
            TagKey original = (TagKey)map.get(values);
            if (original != null) {
                map.put(values, EmiTags.betterTag(key, original));
                continue;
            }
            map.put(values, key);
        }
        return map.values().stream().toList();
    }

    private static <T> TagKey<T> betterTag(TagKey<T> a, TagKey<T> b) {
        String bn;
        if (EmiTags.hasTranslation(a) != EmiTags.hasTranslation(b)) {
            return EmiTags.hasTranslation(a) ? a : b;
        }
        if (EmiTags.hasCustomModel(a) != EmiTags.hasCustomModel(b)) {
            return EmiTags.hasCustomModel(a) ? a : b;
        }
        String an = a.location().getNamespace();
        if (!an.equals(bn = b.location().getNamespace())) {
            if (an.equals("minecraft")) {
                return a;
            }
            if (bn.equals("minecraft")) {
                return b;
            }
            if (an.equals("c")) {
                return a;
            }
            if (bn.equals("c")) {
                return b;
            }
            if (an.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
            if (bn.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (an.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (bn.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
        }
        return a.location().toString().length() <= b.location().toString().length() ? a : b;
    }
}

