/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.runtime;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiLog;
import java.io.File;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.joml.Matrix4f;

public class EmiScreenshotRecorder {
    private static final String SCREENSHOTS_DIRNAME = "screenshots";

    public static void saveScreenshot(String path, int width, int height, Runnable renderer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer));
        } else {
            EmiScreenshotRecorder.saveScreenshotInner(path, width, height, renderer);
        }
    }

    private static void saveScreenshotInner(String path, int width, int height, Runnable renderer) {
        Minecraft client = Minecraft.getInstance();
        int scale = EmiConfig.recipeScreenshotScale < 1 ? EmiPort.getGuiScale(client) : EmiConfig.recipeScreenshotScale;
        TextureTarget framebuffer = new TextureTarget(width * scale, height * scale, true, Minecraft.ON_OSX);
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.clear(Minecraft.ON_OSX);
        framebuffer.bindWrite(true);
        PoseStack view = RenderSystem.getModelViewStack();
        view.pushPose();
        view.setIdentity();
        view.translate(-1.0, 1.0, 0.0);
        view.scale(2.0f / (float)width, -2.0f / (float)height, -0.001f);
        view.translate(0.0, 0.0, 10.0);
        EmiPort.applyModelViewMatrix();
        Matrix4f backupProj = RenderSystem.getProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().identity(), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        renderer.run();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProj, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        view.popPose();
        EmiPort.applyModelViewMatrix();
        framebuffer.unbindWrite();
        client.getMainRenderTarget().bindWrite(true);
        EmiScreenshotRecorder.saveScreenshotInner(client.gameDirectory, path, (RenderTarget)framebuffer, (Component message) -> client.execute(() -> client.gui.getChat().addMessage(message)));
    }

    private static void saveScreenshotInner(File gameDirectory, String suggestedPath, RenderTarget framebuffer, Consumer<Component> messageReceiver) {
        NativeImage nativeImage = EmiScreenshotRecorder.takeScreenshot(framebuffer);
        File screenshots = new File(gameDirectory, SCREENSHOTS_DIRNAME);
        screenshots.mkdir();
        String filename = EmiScreenshotRecorder.getScreenshotFilename(screenshots, suggestedPath);
        File file = new File(screenshots, filename);
        File parent = file.getParentFile();
        parent.mkdirs();
        Util.ioPool().execute(() -> {
            try {
                nativeImage.writeToFile(file);
                MutableComponent text = EmiPort.literal(filename, Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
                messageReceiver.accept((Component)EmiPort.translatable("screenshot.success", text));
            }
            catch (Throwable e) {
                EmiLog.error("Failed to write screenshot", e);
                messageReceiver.accept((Component)EmiPort.translatable("screenshot.failure", e.getMessage()));
            }
            finally {
                nativeImage.close();
            }
        });
    }

    private static NativeImage takeScreenshot(RenderTarget framebuffer) {
        int i = framebuffer.width;
        int j = framebuffer.height;
        NativeImage nativeImage = new NativeImage(i, j, false);
        RenderSystem.bindTexture((int)framebuffer.getColorTextureId());
        nativeImage.downloadTexture(0, false);
        nativeImage.flipY();
        return nativeImage;
    }

    private static String getScreenshotFilename(File directory, String path) {
        int i = 1;
        while (new File(directory, path + (String)(i == 1 ? "" : "_" + i) + ".png").exists()) {
            ++i;
        }
        return path + (String)(i == 1 ? "" : "_" + i) + ".png";
    }
}

