/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigScreen;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;

public class ConfigEnumScreen<T>
extends Screen {
    private final ConfigScreen last;
    private final List<Entry<T>> entries;
    private final Consumer<T> selection;
    private ListWidget list;

    public ConfigEnumScreen(ConfigScreen last, List<Entry<T>> entries, Consumer<T> selection) {
        super((Component)EmiPort.translatable("screen.emi.config"));
        this.last = last;
        this.entries = entries;
        this.selection = selection;
    }

    public void init() {
        super.init();
        this.addRenderableOnly(new EmiNameWidget(this.width / 2, 16));
        int w = 200;
        int x = (this.width - w) / 2;
        this.addRenderableWidget((GuiEventListener)EmiPort.newButton(x, this.height - 30, w, 20, (Component)EmiPort.translatable("gui.done"), button -> this.onClose()));
        this.list = new ListWidget(this.minecraft, this.width, this.height, 40, this.height - 40);
        for (Entry<T> e : this.entries) {
            this.list.addEntry(new SelectionWidget<T>(this, e));
        }
        this.addWidget((GuiEventListener)this.list);
    }

    public void render(GuiGraphics raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.renderDirtBackground(context.raw());
        this.list.render(context.raw(), mouseX, mouseY, delta);
        super.render(context.raw(), mouseX, mouseY, delta);
        ListWidget.Entry entry = this.list.getHoveredEntry();
        if (entry instanceof SelectionWidget) {
            SelectionWidget widget = (SelectionWidget)entry;
            if (widget.button.isHovered()) {
                EmiRenderHelper.drawTooltip(this, context, widget.tooltip, mouseX, mouseY);
            }
        }
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    public void onClose() {
        Minecraft.getInstance().setScreen((Screen)this.last);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (this.minecraft.options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        if (keyCode == 258) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public record Entry<T>(T value, Component name, List<ClientTooltipComponent> tooltip) {
    }

    public static class SelectionWidget<T>
    extends ListWidget.Entry {
        private final Button button;
        private final List<ClientTooltipComponent> tooltip;

        public SelectionWidget(ConfigEnumScreen<T> screen, Entry<T> e) {
            this.button = EmiPort.newButton(0, 0, 200, 20, e.name(), t -> {
                screen.selection.accept(e.value());
                screen.onClose();
            });
            this.tooltip = e.tooltip();
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @Override
        public void render(GuiGraphics raw, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.y = y;
            this.button.x = x + width / 2 - this.button.getWidth() / 2;
            this.button.render(raw, mouseX, mouseY, delta);
        }

        @Override
        public int getHeight() {
            return 20;
        }
    }
}

