/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.RotatableLamp;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;

public class ThinLamp
extends RotatableLamp {
    private final double thickness;

    public ThinLamp(double thickness) {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.NORMAL).lightLevel($ -> 15).strength(1.0f));
        this.thickness = thickness;
        this.UP = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)16.0);
        this.DOWN = Block.box((double)0.0, (double)(16.0 - thickness), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0);
        this.WEST = Block.box((double)(16.0 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.NORTH = Block.box((double)0.0, (double)0.0, (double)(16.0 - thickness), (double)16.0, (double)16.0, (double)16.0);
        this.SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext useContext) {
        boolean waterlogged;
        BlockPos pos = useContext.getClickedPos().relative(useContext.getClickedFace().getOpposite());
        boolean bl = waterlogged = useContext.getLevel().getFluidState(useContext.getClickedPos()).getType() == Fluids.WATER;
        if (useContext.getPlayer() != null && useContext.getLevel().getBlockState(pos).getBlock() instanceof ThinLamp && !useContext.getPlayer().isCrouching()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)useContext.getLevel().getBlockState(pos).getValue((Property)BlockStateProperties.FACING)));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)useContext.getClickedFace())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String base = this.getDescriptionId();
        if (this.thickness == 8.0) {
            consumer.accept(base, "Illuminant Slab");
            consumer.accept(base + ".info", "Simple half-slab light,");
        } else {
            consumer.accept(base, "Illuminant Panel");
            consumer.accept(base + ".info", "Simple LED panel light,");
        }
        consumer.accept(base + ".info2", "Place in any direction.");
    }
}

