/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.neoforge.mixin.client;

import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import java.util.List;
import net.minecraft.client.Options;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
abstract class OptionsMixin {
    @Shadow
    public List<String> resourcePacks;
    @Shadow
    public List<String> incompatibleResourcePacks;
    @Unique
    private boolean resourcePackOverrides$wasEmpty;

    OptionsMixin() {
    }

    @Inject(method={"load(Z)V"}, at={@At(value="RETURN")}, remap=false)
    private void load(boolean limited, CallbackInfo callback) {
        if (this.resourcePacks.isEmpty()) {
            this.resourcePackOverrides$wasEmpty = true;
            List<String> defaultResourcePacks = ResourceOverridesManager.getDefaultResourcePacks(false);
            this.resourcePacks.removeAll(defaultResourcePacks);
            this.resourcePacks.addAll(defaultResourcePacks);
        }
    }

    @Inject(method={"loadSelectedResourcePacks"}, at={@At(value="HEAD")})
    public void loadSelectedResourcePacks(PackRepository resourcePackList, CallbackInfo callback) {
        if (this.resourcePackOverrides$wasEmpty) {
            this.resourcePackOverrides$wasEmpty = false;
            for (String s : ResourceOverridesManager.getDefaultResourcePacks(false)) {
                Pack pack = resourcePackList.getPack(s);
                if (pack == null && !s.startsWith("file/")) {
                    pack = resourcePackList.getPack("file/" + s);
                }
                if (pack == null || pack.getCompatibility().isCompatible()) continue;
                this.incompatibleResourcePacks.add(s);
            }
        }
    }
}

