/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.client.gui.radial_menu;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrbysco.horsingaround.client.gui.radial_menu.RadialMenu;
import com.mrbysco.horsingaround.client.gui.radial_menu.RadialMenuSlot;
import com.mrbysco.horsingaround.client.gui.radial_menu.SecondaryIconPosition;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiRadialMenu<T>
extends Screen {
    private static final float PRECISION = 5.0f;
    private static final int MAX_SLOTS = 20;
    private boolean closing;
    private RadialMenu<T> radialMenu;
    private List<RadialMenuSlot<T>> radialMenuSlots;
    final float OPEN_ANIMATION_LENGTH = 0.4f;
    private float totalTime;
    private float prevTick;
    private float extraTick;
    private int selectedItem;
    public ItemRenderer itemRenderer;

    public GuiRadialMenu(RadialMenu<T> radialMenu) {
        super((Component)Component.literal((String)""));
        this.radialMenu = radialMenu;
        this.radialMenuSlots = this.radialMenu.getRadialMenuSlots();
        this.closing = false;
        this.minecraft = Minecraft.getInstance();
        this.selectedItem = -1;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    @SubscribeEvent
    public static void updateInputEvent(MovementInputUpdateEvent event) {
        if (Minecraft.getInstance().screen instanceof GuiRadialMenu) {
            Options settings = Minecraft.getInstance().options;
            Input eInput = event.getInput();
            long window = Minecraft.getInstance().getWindow().getWindow();
            eInput.up = InputConstants.isKeyDown((long)window, (int)settings.keyUp.getKey().getValue());
            eInput.down = InputConstants.isKeyDown((long)window, (int)settings.keyDown.getKey().getValue());
            eInput.left = InputConstants.isKeyDown((long)window, (int)settings.keyLeft.getKey().getValue());
            eInput.right = InputConstants.isKeyDown((long)window, (int)settings.keyRight.getKey().getValue());
            float f = eInput.up == eInput.down ? 0.0f : (eInput.forwardImpulse = eInput.up ? 1.0f : -1.0f);
            eInput.leftImpulse = eInput.left == eInput.right ? 0.0f : (eInput.left ? 1.0f : -1.0f);
            eInput.jumping = InputConstants.isKeyDown((long)window, (int)settings.keyJump.getKey().getValue());
            eInput.shiftKeyDown = InputConstants.isKeyDown((long)window, (int)settings.keyShift.getKey().getValue());
            if (Minecraft.getInstance().player.isMovingSlowly()) {
                eInput.leftImpulse = (float)((double)eInput.leftImpulse * 0.3);
                eInput.forwardImpulse = (float)((double)eInput.forwardImpulse * 0.3);
            }
        }
    }

    public void tick() {
        if (this.totalTime != 0.4f) {
            this.extraTick += 1.0f;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int adjusted;
        float sliceBorderRight;
        float sliceBorderLeft;
        int i;
        super.render(graphics, mouseX, mouseY, partialTicks);
        PoseStack ms = graphics.pose();
        float openAnimation = this.closing ? 1.0f - this.totalTime / 0.4f : this.totalTime / 0.4f;
        float currTick = this.minecraft.getFrameTime();
        this.totalTime += (currTick + this.extraTick - this.prevTick) / 20.0f;
        this.extraTick = 0.0f;
        this.prevTick = currTick;
        float animProgress = Mth.clamp((float)openAnimation, (float)0.0f, (float)1.0f);
        animProgress = (float)(1.0 - Math.pow(1.0f - animProgress, 3.0));
        float radiusIn = Math.max(0.1f, 45.0f * animProgress);
        float radiusOut = radiusIn * 2.0f;
        float itemRadius = (radiusIn + radiusOut) * 0.5f;
        int centerOfScreenX = this.width / 2;
        int centerOfScreenY = this.height / 2;
        int numberOfSlices = Math.min(20, this.radialMenuSlots.size());
        double mousePositionInDegreesInRelationToCenterOfScreen = Math.toDegrees(Math.atan2(mouseY - centerOfScreenY, mouseX - centerOfScreenX));
        double mouseDistanceToCenterOfScreen = Math.sqrt(Math.pow(mouseX - centerOfScreenX, 2.0) + Math.pow(mouseY - centerOfScreenY, 2.0));
        float slot0 = (-0.5f / (float)numberOfSlices + 0.25f) * 360.0f;
        if (mousePositionInDegreesInRelationToCenterOfScreen < (double)slot0) {
            mousePositionInDegreesInRelationToCenterOfScreen += 360.0;
        }
        ms.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        boolean hasMouseOver = false;
        int mousedOverSlot = -1;
        if (!this.closing) {
            this.selectedItem = -1;
            for (i = 0; i < numberOfSlices; ++i) {
                sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
                if (!(mousePositionInDegreesInRelationToCenterOfScreen >= (double)sliceBorderLeft) || !(mousePositionInDegreesInRelationToCenterOfScreen < (double)sliceBorderRight) || !(mouseDistanceToCenterOfScreen >= (double)radiusIn) || !(mouseDistanceToCenterOfScreen < (double)radiusOut)) continue;
                this.selectedItem = i;
                break;
            }
        }
        for (i = 0; i < numberOfSlices; ++i) {
            sliceBorderLeft = (((float)i - 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            sliceBorderRight = (((float)i + 0.5f) / (float)numberOfSlices + 0.25f) * 360.0f;
            if (this.selectedItem == i) {
                this.drawSlice(buffer, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 63, 161, 191, 60);
                hasMouseOver = true;
                mousedOverSlot = this.selectedItem;
                continue;
            }
            this.drawSlice(buffer, centerOfScreenX, centerOfScreenY, 10.0f, radiusIn, radiusOut, sliceBorderLeft, sliceBorderRight, 0, 0, 0, 64);
        }
        tesselator.end();
        RenderSystem.disableBlend();
        if (hasMouseOver && mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
            String string = this.radialMenuSlots.get(adjusted).slotName();
            int n = this.width / 2;
            Objects.requireNonNull(this.font);
            graphics.drawCenteredString(this.font, string, n, (this.height - 9) / 2, 0xFFFFFF);
        }
        ms.popPose();
        for (i = 0; i < numberOfSlices; ++i) {
            ItemStack stack = new ItemStack((ItemLike)Blocks.DIRT);
            float angle1 = ((float)i / (float)numberOfSlices - 0.25f) * 2.0f * (float)Math.PI;
            if (numberOfSlices % 2 != 0) {
                angle1 += (float)(Math.PI / (double)numberOfSlices);
            }
            float posX = (float)(centerOfScreenX - 8) + itemRadius * (float)Math.cos(angle1);
            float posY = (float)(centerOfScreenY - 8) + itemRadius * (float)Math.sin(angle1);
            RenderSystem.disableDepthTest();
            T primarySlotIcon = this.radialMenuSlots.get(i).primarySlotIcon();
            List<T> secondarySlotIcons = this.radialMenuSlots.get(i).secondarySlotIcons();
            if (primarySlotIcon != null) {
                this.radialMenu.drawIcon(primarySlotIcon, graphics, (int)posX, (int)posY, 16);
                if (secondarySlotIcons != null && !secondarySlotIcons.isEmpty()) {
                    this.drawSecondaryIcons(graphics, (int)posX, (int)posY, secondarySlotIcons);
                }
            }
            ms.pushPose();
            ms.translate(0.0f, 0.0f, 9999.0f);
            this.drawSliceName(graphics, String.valueOf(i + 1), stack, (int)posX, (int)posY);
            ms.popPose();
        }
        if (mousedOverSlot != -1) {
            adjusted = (mousedOverSlot + (numberOfSlices / 2 + 1)) % numberOfSlices - 1;
            this.selectedItem = adjusted = adjusted == -1 ? numberOfSlices - 1 : adjusted;
        }
    }

    public void drawSecondaryIcons(GuiGraphics ms, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, List<T> secondarySlotIcons) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            this.drawSecondaryIcon(ms, secondarySlotIcons.get(0), positionXOfPrimaryIcon, positionYOfPrimaryIcon, this.radialMenu.getSecondaryIconStartingPosition());
        } else {
            SecondaryIconPosition currentSecondaryIconPosition = this.radialMenu.getSecondaryIconStartingPosition();
            for (T secondarySlotIcon : secondarySlotIcons) {
                this.drawSecondaryIcon(ms, secondarySlotIcon, positionXOfPrimaryIcon, positionYOfPrimaryIcon, currentSecondaryIconPosition);
                currentSecondaryIconPosition = SecondaryIconPosition.getNextPosition(currentSecondaryIconPosition);
            }
        }
    }

    public void drawSecondaryIcon(GuiGraphics poseStack, T item, int positionXOfPrimaryIcon, int positionYOfPrimaryIcon, SecondaryIconPosition secondaryIconPosition) {
        int offset = this.radialMenu.getOffset();
        switch (secondaryIconPosition) {
            case NORTH: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon - 14 + offset, 10);
                break;
            }
            case EAST: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + 14 + offset, positionYOfPrimaryIcon + offset, 10);
                break;
            }
            case SOUTH: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon + offset, positionYOfPrimaryIcon + 14 + offset, 10);
                break;
            }
            case WEST: {
                this.radialMenu.drawIcon(item, poseStack, positionXOfPrimaryIcon - 14 + offset, positionYOfPrimaryIcon + offset, 10);
            }
        }
    }

    public void drawSliceName(GuiGraphics graphics, String sliceName, ItemStack stack, int posX, int posY) {
        if (!this.radialMenu.isShowMoreSecondaryItems()) {
            graphics.renderItemDecorations(this.font, stack, posX + 5, posY, sliceName);
        } else {
            graphics.renderItemDecorations(this.font, stack, posX + 5, posY + 5, sliceName);
        }
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        int adjustedKey = key - 48;
        if (adjustedKey >= 0 && adjustedKey < this.radialMenuSlots.size()) {
            this.selectedItem = adjustedKey == 0 ? this.radialMenuSlots.size() : adjustedKey;
            --this.selectedItem;
            this.mouseClicked(0.0, 0.0, 0);
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.selectedItem != -1) {
            this.radialMenu.setCurrentSlot(this.selectedItem);
            this.minecraft.player.closeContainer();
        }
        return true;
    }

    public void drawSlice(BufferBuilder buffer, float x, float y, float z, float radiusIn, float radiusOut, float startAngle, float endAngle, int r, int g, int b, int a) {
        float angle = endAngle - startAngle;
        int sections = Math.max(1, Mth.ceil((float)(angle / 5.0f)));
        startAngle = (float)Math.toRadians(startAngle);
        endAngle = (float)Math.toRadians(endAngle);
        angle = endAngle - startAngle;
        for (int i = 0; i < sections; ++i) {
            float angle1 = startAngle + (float)i / (float)sections * angle;
            float angle2 = startAngle + (float)(i + 1) / (float)sections * angle;
            float pos1InX = x + radiusIn * (float)Math.cos(angle1);
            float pos1InY = y + radiusIn * (float)Math.sin(angle1);
            float pos1OutX = x + radiusOut * (float)Math.cos(angle1);
            float pos1OutY = y + radiusOut * (float)Math.sin(angle1);
            float pos2OutX = x + radiusOut * (float)Math.cos(angle2);
            float pos2OutY = y + radiusOut * (float)Math.sin(angle2);
            float pos2InX = x + radiusIn * (float)Math.cos(angle2);
            float pos2InY = y + radiusIn * (float)Math.sin(angle2);
            buffer.vertex((double)pos1OutX, (double)pos1OutY, (double)z).color(r, g, b, a).endVertex();
            buffer.vertex((double)pos1InX, (double)pos1InY, (double)z).color(r, g, b, a).endVertex();
            buffer.vertex((double)pos2InX, (double)pos2InY, (double)z).color(r, g, b, a).endVertex();
            buffer.vertex((double)pos2OutX, (double)pos2OutY, (double)z).color(r, g, b, a).endVertex();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

