/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mrbysco.horsingaround.network.message.SyncPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public class CallData
extends SavedData {
    private final ListMultimap<UUID, TamedData> playerTamedMap = ArrayListMultimap.create();
    private static final String DATA_NAME = "horsingaround_data";

    public CallData(ListMultimap<UUID, TamedData> tamedMap) {
        this.playerTamedMap.clear();
        if (!tamedMap.isEmpty()) {
            this.playerTamedMap.putAll(tamedMap);
        }
    }

    public CallData() {
        this((ListMultimap<UUID, TamedData>)ArrayListMultimap.create());
    }

    public void addTamedData(UUID playerUUID, Entity entity) {
        List<TamedData> dataList = this.getTamedData(playerUUID);
        boolean known = dataList.stream().anyMatch(tamedData -> tamedData.uuid().equals(entity.getUUID()));
        if (!known) {
            TamedData tamedData2 = TamedData.createData(entity.getUUID(), entity);
            this.playerTamedMap.put((Object)playerUUID, (Object)tamedData2);
        } else {
            dataList.stream().filter(tamedData -> tamedData.uuid().equals(entity.getUUID())).findFirst().ifPresent(tamedData -> {
                CompoundTag data = entity.saveWithoutId(tamedData.tag());
                data.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            });
        }
        this.syncData(playerUUID);
        this.setDirty();
    }

    public void removeTamedData(UUID playerUUID, Entity entity) {
        this.removeTamedData(playerUUID, entity.getUUID());
    }

    public void removeTamedData(UUID playerUUID, UUID entityUUID) {
        List tamedDataList = this.playerTamedMap.get((Object)playerUUID);
        tamedDataList.removeIf(tamedData -> tamedData.uuid().equals(entityUUID));
        this.syncData(playerUUID);
        this.setDirty();
    }

    public List<TamedData> getTamedData(UUID playerUUID) {
        return this.playerTamedMap.get((Object)playerUUID);
    }

    public boolean hasTamedData(UUID playerUUID) {
        return this.playerTamedMap.containsKey((Object)playerUUID);
    }

    public boolean isKnown(UUID uuid) {
        return this.playerTamedMap.values().stream().anyMatch(tamedData -> tamedData.uuid().equals(uuid));
    }

    public void updateData(UUID uuid, Entity entity) {
        this.playerTamedMap.values().stream().filter(tamedData -> tamedData.uuid().equals(uuid)).findFirst().ifPresent(tamedData -> {
            CompoundTag data = entity.saveWithoutId(tamedData.tag());
            data.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
        });
        this.setDirty();
    }

    public void syncData(UUID playerUUID) {
        List tamedDataList = this.playerTamedMap.get((Object)playerUUID);
        CompoundTag tag = new CompoundTag();
        this.saveList(tag, playerUUID, tamedDataList);
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new SyncPayload(playerUUID, tag)});
    }

    public void syncData() {
        Set players = this.playerTamedMap.keySet();
        for (UUID playerUUID : players) {
            List tamedDataList = this.playerTamedMap.get((Object)playerUUID);
            CompoundTag tag = new CompoundTag();
            this.saveList(tag, playerUUID, tamedDataList);
            PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new SyncPayload(playerUUID, tag)});
        }
    }

    public static CallData load(CompoundTag tag) {
        ArrayListMultimap tamedMap = ArrayListMultimap.create();
        for (String uuid : tag.getAllKeys()) {
            Tag nbt;
            ListTag dataListTag = new ListTag();
            if (tag.getTagType(uuid) == 9 && (nbt = tag.get(uuid)) instanceof ListTag) {
                ListTag listNBT = (ListTag)nbt;
                if (!listNBT.isEmpty() && listNBT.getElementType() != 10) continue;
                dataListTag = listNBT;
            }
            if (dataListTag.isEmpty()) continue;
            ArrayList<TamedData> dataList = new ArrayList<TamedData>();
            for (int i = 0; i < dataListTag.size(); ++i) {
                CompoundTag dataTag = dataListTag.getCompound(i);
                TamedData data = TamedData.load(dataTag);
                if (data == null) continue;
                dataList.add(data);
            }
            tamedMap.putAll((Object)UUID.fromString(uuid), dataList);
        }
        return new CallData((ListMultimap<UUID, TamedData>)tamedMap);
    }

    public CompoundTag save(CompoundTag compound) {
        for (UUID playerUUID : this.playerTamedMap.keySet()) {
            List tamedDataList = this.playerTamedMap.get((Object)playerUUID);
            this.saveList(compound, playerUUID, tamedDataList);
        }
        return compound;
    }

    public void saveList(CompoundTag tag, UUID playerUUID, List<TamedData> dataList) {
        ListTag dataListTag = new ListTag();
        for (TamedData tamedData : dataList) {
            CompoundTag data = new CompoundTag();
            tamedData.save(data);
            dataListTag.add((Object)data);
        }
        tag.put(playerUUID.toString(), (Tag)dataListTag);
    }

    public static CallData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerLevel overworld = world.getServer().getLevel(Level.OVERWORLD);
        DimensionDataStorage storage = overworld.getDataStorage();
        return (CallData)storage.computeIfAbsent(new SavedData.Factory(CallData::new, CallData::load), DATA_NAME);
    }

    public record TamedData(UUID uuid, CompoundTag tag, String name) {
        public static TamedData createData(UUID uuid, Entity entity) {
            CompoundTag data = entity.saveWithoutId(new CompoundTag());
            data.putString("id", EntityType.getKey((EntityType)entity.getType()).toString());
            return new TamedData(uuid, data, entity.getDisplayName().getString());
        }

        public void save(CompoundTag compound) {
            compound.putUUID("UUID", this.uuid);
            compound.put("Tag", (Tag)this.tag);
            compound.putString("Name", this.name);
        }

        public Entity createEntity(Level level) {
            return EntityType.loadEntityRecursive((CompoundTag)this.tag, (Level)level, entity -> {
                entity.setUUID(this.uuid);
                return entity;
            });
        }

        public static TamedData load(CompoundTag compound) {
            if (!compound.contains("UUID") || !compound.contains("Tag")) {
                return null;
            }
            UUID uuid = compound.getUUID("UUID");
            CompoundTag tag = compound.getCompound("Tag");
            String name = compound.getString("Name");
            return new TamedData(uuid, tag, name);
        }
    }
}

