/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.datagen;

import com.mrbysco.horsingaround.datagen.client.HorsingLanguageProvider;
import com.mrbysco.horsingaround.datagen.client.HorsingSoundProvider;
import com.mrbysco.horsingaround.datagen.server.HorsingItemTagProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HorsingDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            BlockTagsProvider tagProvider = new BlockTagsProvider(packOutput, lookupProvider, "horsingaround", helper){

                protected void addTags(HolderLookup.Provider provider) {
                }
            };
            generator.addProvider(true, (DataProvider)tagProvider);
            generator.addProvider(true, (DataProvider)new HorsingItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)tagProvider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new HorsingLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new HorsingSoundProvider(packOutput, helper));
        }
    }
}

