/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.handler;

import com.mrbysco.horsingaround.data.CallData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class SyncHandler {
    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            CallData callData = CallData.get(player.level());
            callData.syncData(player.getUUID());
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingTickEvent event) {
        CallData callData;
        OwnableEntity ownableEntity;
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.level().isClientSide && livingEntity.tickCount % 80 == 0 && livingEntity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)livingEntity).getOwnerUUID() != null && (callData = CallData.get(livingEntity.level())).isKnown(livingEntity.getUUID())) {
            callData.updateData(livingEntity.getUUID(), (Entity)livingEntity);
        }
    }
}

