/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.network.handler;

import com.mrbysco.horsingaround.client.ClientHandler;
import com.mrbysco.horsingaround.data.CallData;
import com.mrbysco.horsingaround.network.message.SyncPayload;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSync(SyncPayload syncData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> context.player().ifPresent(player -> {
            UUID playerUUID = syncData.playerUUID();
            if (player.getUUID().equals(playerUUID)) {
                Tag nbt;
                ClientHandler.tamedList.clear();
                CompoundTag data = syncData.data();
                ListTag dataListTag = new ListTag();
                String uuid = playerUUID.toString();
                if (data.getTagType(uuid) == 9 && (nbt = data.get(uuid)) instanceof ListTag) {
                    ListTag listNBT = (ListTag)nbt;
                    if (!listNBT.isEmpty() && listNBT.getElementType() != 10) {
                        return;
                    }
                    dataListTag = listNBT;
                }
                if (!dataListTag.isEmpty()) {
                    ArrayList<CallData.TamedData> dataList = new ArrayList<CallData.TamedData>();
                    for (int i = 0; i < dataListTag.size(); ++i) {
                        CompoundTag dataTag = dataListTag.getCompound(i);
                        CallData.TamedData tamedData = CallData.TamedData.load(dataTag);
                        if (tamedData == null) continue;
                        dataList.add(tamedData);
                    }
                    ClientHandler.tamedList.addAll(dataList);
                }
            }
        })).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"horsingaround.networking.sync.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

