/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.network.handler;

import com.mrbysco.horsingaround.data.CallData;
import com.mrbysco.horsingaround.network.message.SummonPayload;
import com.mrbysco.horsingaround.network.message.UnlinkPayload;
import com.mrbysco.horsingaround.registry.HorsingRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSummon(SummonPayload summonData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Object patt1083$temp = context.player().get();
            if (patt1083$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt1083$temp;
                ServerLevel level = player.serverLevel();
                UUID mobUUID = summonData.mobUUID();
                Entity mob = level.getEntity(mobUUID);
                CallData callData = CallData.get(player.level());
                if (mob == null) {
                    List<CallData.TamedData> tamedList = callData.getTamedData(player.getUUID());
                    CallData.TamedData matchingData = null;
                    for (CallData.TamedData data : tamedList) {
                        if (!data.uuid().equals(mobUUID)) continue;
                        matchingData = data;
                        break;
                    }
                    if (matchingData != null) {
                        Entity entity = matchingData.createEntity(player.level());
                        entity.setPos(player.position());
                        level.addFreshEntity(entity);
                    }
                } else {
                    mob.teleportTo(player.getX(), player.getY(), player.getZ());
                    callData.updateData(mob.getUUID(), mob);
                }
                callData.syncData(player.getUUID());
                level.playSound((Player)null, player.blockPosition(), (SoundEvent)HorsingRegistry.CALL.get(), player.getSoundSource(), 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"horsingaround.networking.summon.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleUnlink(UnlinkPayload unlinkData, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            if (context.player().isPresent()) {
                Player player = (Player)context.player().get();
                CallData callData = CallData.get(player.level());
                callData.removeTamedData(player.getUUID(), unlinkData.mobUUID());
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"horsingaround.networking.unlink.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

