/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.ArmorStandChances;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ArmorStandProcessor
extends StructureProcessor {
    public static final ArmorStandProcessor INSTANCE = new ArmorStandProcessor();
    public static final Codec<StructureProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureEntityInfo processEntity(LevelReader levelReader, BlockPos structurePiecePos, StructureTemplate.StructureEntityInfo localEntityInfo, StructureTemplate.StructureEntityInfo globalEntityInfo, StructurePlaceSettings structurePlaceSettings, StructureTemplate template) {
        if (globalEntityInfo.nbt.getString("id").equals("minecraft:armor_stand")) {
            String helmet;
            ListTag armorItems = globalEntityInfo.nbt.getList("ArmorItems", 10);
            RandomSource randomSource = structurePlaceSettings.getRandom(globalEntityInfo.blockPos);
            try {
                helmet = ((CompoundTag)armorItems.get(3)).get("id").toString();
            }
            catch (Exception e) {
                BetterDesertTemplesCommon.LOGGER.info("Unable to randomize armor stand at {}. Missing helmet?", (Object)globalEntityInfo.blockPos);
                return globalEntityInfo;
            }
            CompoundTag newNBT = globalEntityInfo.nbt.copy();
            if (helmet.equals("\"minecraft:iron_helmet\"")) {
                ListTag armorItemsList = newNBT.getList("ArmorItems", 10);
                String bootsString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getArmoryBoots(randomSource)).toString();
                armorItemsList.getCompound(0).putString("id", bootsString);
                armorItemsList.getCompound(0).putByte("Count", (byte)1);
                armorItemsList.getCompound(0).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String leggingsString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getArmoryLeggings(randomSource)).toString();
                armorItemsList.getCompound(1).putString("id", leggingsString);
                armorItemsList.getCompound(1).putByte("Count", (byte)1);
                armorItemsList.getCompound(1).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String chestplateString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getArmoryChestplate(randomSource)).toString();
                armorItemsList.getCompound(2).putString("id", chestplateString);
                armorItemsList.getCompound(2).putByte("Count", (byte)1);
                armorItemsList.getCompound(2).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String helmetString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getArmoryHelmet(randomSource)).toString();
                armorItemsList.getCompound(3).putString("id", helmetString);
                armorItemsList.getCompound(3).putByte("Count", (byte)1);
                armorItemsList.getCompound(3).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            } else if (helmet.equals("\"minecraft:leather_helmet\"")) {
                ListTag armorItemsList = newNBT.getList("ArmorItems", 10);
                String bootsString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getWardrobeBoots(randomSource)).toString();
                armorItemsList.getCompound(0).putString("id", bootsString);
                armorItemsList.getCompound(0).putByte("Count", (byte)1);
                armorItemsList.getCompound(0).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String leggingsString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getWardrobeLeggings(randomSource)).toString();
                armorItemsList.getCompound(1).putString("id", leggingsString);
                armorItemsList.getCompound(1).putByte("Count", (byte)1);
                armorItemsList.getCompound(1).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String chestplateString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getWardrobeChestplate(randomSource)).toString();
                armorItemsList.getCompound(2).putString("id", chestplateString);
                armorItemsList.getCompound(2).putByte("Count", (byte)1);
                armorItemsList.getCompound(2).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
                String helmetString = BuiltInRegistries.ITEM.getKey((Object)ArmorStandChances.get().getWardrobeHelmet(randomSource)).toString();
                armorItemsList.getCompound(3).putString("id", helmetString);
                armorItemsList.getCompound(3).putByte("Count", (byte)1);
                armorItemsList.getCompound(3).put("tag", (Tag)Util.make((Object)new CompoundTag(), compoundTag -> compoundTag.putInt("Damage", 0)));
            } else {
                BetterDesertTemplesCommon.LOGGER.info("Armor stand at {} has invalid helmet. Found: {}", (Object)globalEntityInfo.blockPos, (Object)helmet);
                return globalEntityInfo;
            }
            globalEntityInfo = new StructureTemplate.StructureEntityInfo(globalEntityInfo.pos, globalEntityInfo.blockPos, newNBT);
        }
        return globalEntityInfo;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorModule.ARMOR_STAND_PROCESSOR;
    }
}

