/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import com.yungnickyoung.minecraft.yungsapi.world.spawner.MobSpawnerData;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class YellowWoolProcessor
extends StructureProcessor {
    public static final YellowWoolProcessor INSTANCE = new YellowWoolProcessor();
    public static final Codec<YellowWoolProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() == Blocks.YELLOW_WOOL) {
            MobSpawnerData spawnerData = MobSpawnerData.builder().setEntityType(EntityType.HUSK).maxNearbyEntities(8).requiredPlayerRange(24).build();
            spawnerData.nextSpawnData.getEntityToSpawn().put("HandItems", (Tag)Util.make((Object)new ListTag(), handItemsTag -> {
                handItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), handItem1Tag -> {
                    handItem1Tag.putString("id", "minecraft:golden_sword");
                    handItem1Tag.putByte("Count", (byte)1);
                })));
                handItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), handItem2Tag -> {
                    handItem2Tag.putString("id", "minecraft:shield");
                    handItem2Tag.putByte("Count", (byte)1);
                    handItem2Tag.put("tag", (Tag)Util.make((Object)new CompoundTag(), tagNbt -> tagNbt.put("BlockEntityTag", (Tag)Util.make((Object)new CompoundTag(), blockEntityTag -> {
                        blockEntityTag.putInt("Base", 11);
                        blockEntityTag.put("Patterns", (Tag)Util.make((Object)new ListTag(), patternsTag -> {
                            patternsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), patternTag -> {
                                patternTag.putInt("Color", 4);
                                patternTag.putString("Pattern", "ss");
                            })));
                            patternsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), patternTag -> {
                                patternTag.putInt("Color", 4);
                                patternTag.putString("Pattern", "ms");
                            })));
                            patternsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), patternTag -> {
                                patternTag.putInt("Color", 4);
                                patternTag.putString("Pattern", "mc");
                            })));
                            patternsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), patternTag -> {
                                patternTag.putInt("Color", 15);
                                patternTag.putString("Pattern", "hhb");
                            })));
                        }));
                    }))));
                })));
                handItemsTag.add((Object)new CompoundTag());
            }));
            spawnerData.nextSpawnData.getEntityToSpawn().put("ArmorItems", (Tag)Util.make((Object)new ListTag(), armorItemsTag -> {
                armorItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), armorItem1Tag -> {
                    armorItem1Tag.putString("id", "minecraft:leather_boots");
                    armorItem1Tag.putByte("Count", (byte)1);
                    armorItem1Tag.put("tag", (Tag)Util.make((Object)new CompoundTag(), tagNbt -> tagNbt.put("display", (Tag)Util.make((Object)new CompoundTag(), displayTag -> displayTag.putInt("color", 0)))));
                })));
                armorItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), armorItem2Tag -> {
                    armorItem2Tag.putString("id", "minecraft:leather_leggings");
                    armorItem2Tag.putByte("Count", (byte)1);
                    armorItem2Tag.put("tag", (Tag)Util.make((Object)new CompoundTag(), tagNbt -> tagNbt.put("display", (Tag)Util.make((Object)new CompoundTag(), displayTag -> displayTag.putInt("color", 0x1100FF)))));
                })));
                armorItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), armorItem3Tag -> {
                    armorItem3Tag.putString("id", "minecraft:golden_chestplate");
                    armorItem3Tag.putByte("Count", (byte)1);
                })));
                armorItemsTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), armorItem4Tag -> {
                    armorItem4Tag.putString("id", "minecraft:chainmail_helmet");
                    armorItem4Tag.putByte("Count", (byte)1);
                })));
            }));
            CompoundTag nbt = spawnerData.save();
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.SPAWNER.defaultBlockState(), nbt);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorModule.YELLOW_WOOL_PROCESSOR;
    }
}

