/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;

public abstract class PlaceableFluid
extends Fluid {
    public static final float EIGHT_NINTHS = 0.8888889f;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey>(200){

            protected void rehash(int newN) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });
    protected final StateDefinition<Fluid, FluidState> stateDefinition;
    private final Map<FluidState, VoxelShape> shapeMap = new IdentityHashMap<FluidState, VoxelShape>();
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluid(int maxLevel) {
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.create((String)"level", (int)1, (int)(maxLevel + 1));
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createFluidStateDefinition((StateDefinition.Builder<Fluid, FluidState>)builder);
        this.stateDefinition = builder.create(Fluid::defaultFluidState, FluidState::new);
        this.registerDefaultState((FluidState)((FluidState)this.stateDefinition.any()).setValue((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        if (this.levelProperty != null) {
            builder.add(new Property[]{this.levelProperty});
        }
    }

    public StateDefinition<Fluid, FluidState> getStateDefinition() {
        return this.stateDefinition;
    }

    protected boolean canBeReplacedWith(FluidState fluidState, BlockGetter world, BlockPos pos, Fluid fluid, Direction face) {
        return face == Direction.DOWN && !this.isSame(fluid);
    }

    protected abstract int getDropOff(LevelReader var1);

    protected BlockState createLegacyBlock(FluidState fluidState) {
        PlaceableFluidBlock block = this.getFluidBlock();
        IntegerProperty blockLevelProperty = block.getLevelProperty();
        int fluidLevel = (Integer)fluidState.getValue((Property)this.levelProperty);
        int blockLevel = fluidLevel > this.maxLevel ? this.maxLevel : this.maxLevel - fluidLevel;
        return (BlockState)block.defaultBlockState().setValue((Property)blockLevelProperty, (Comparable)Integer.valueOf(blockLevel));
    }

    protected abstract PlaceableFluidBlock getFluidBlock();

    protected Vec3 getFlow(BlockGetter world, BlockPos pos, FluidState state) {
        double x = 0.0;
        double y = 0.0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            mutablePos.setWithOffset((Vec3i)pos, offset);
            FluidState offsetState = world.getFluidState((BlockPos)mutablePos);
            if (!this.affectsFlow(offsetState)) continue;
            float offsetHeight = offsetState.getOwnHeight();
            float heightDiff = 0.0f;
            if (offsetHeight == 0.0f) {
                BlockPos posDown;
                FluidState belowState;
                if (!world.getBlockState((BlockPos)mutablePos).blocksMotion() && this.affectsFlow(belowState = world.getFluidState(posDown = mutablePos.below())) && (offsetHeight = belowState.getOwnHeight()) > 0.0f) {
                    heightDiff = state.getOwnHeight() - offsetHeight + 0.8888889f;
                }
            } else if (offsetHeight > 0.0f) {
                heightDiff = state.getOwnHeight() - offsetHeight;
            }
            if (heightDiff == 0.0f) continue;
            x += (double)((float)offset.getStepX() * heightDiff);
            y += (double)((float)offset.getStepZ() * heightDiff);
        }
        Vec3 flow = new Vec3(x, 0.0, y);
        if ((Integer)state.getValue((Property)this.levelProperty) == 0) {
            for (Direction offset : Direction.Plane.HORIZONTAL) {
                mutablePos.setWithOffset((Vec3i)pos, offset);
                if (!this.isSolidFace(world, (BlockPos)mutablePos, offset) && !this.isSolidFace(world, mutablePos.above(), offset)) continue;
                flow = flow.normalize().add(0.0, -6.0, 0.0);
                break;
            }
        }
        return flow.normalize();
    }

    private boolean affectsFlow(FluidState otherState) {
        return otherState.isEmpty() || otherState.getType().isSame((Fluid)this);
    }

    protected boolean isSolidFace(BlockGetter world, BlockPos pos, Direction face) {
        BlockState blockState = world.getBlockState(pos);
        FluidState fluidState = world.getFluidState(pos);
        return !fluidState.getType().isSame((Fluid)this) && (face == Direction.UP || !(blockState.getBlock() instanceof IceBlock) && blockState.isFaceSturdy(world, pos, face));
    }

    protected void spread(Level world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.isEmpty()) {
            BlockState blockState = world.getBlockState(pos);
            BlockPos downPos = pos.below();
            BlockState downBlockState = world.getBlockState(downPos);
            FluidState newFluidState = this.getNewLiquid(world, downPos, downBlockState);
            if (this.canSpreadTo((BlockGetter)world, pos, blockState, Direction.DOWN, downPos, downBlockState, world.getFluidState(downPos), newFluidState.getType())) {
                this.spreadTo((LevelAccessor)world, downPos, downBlockState, Direction.DOWN, newFluidState);
                if (this.sourceNeighborCount((LevelReader)world, pos) >= 3) {
                    this.spreadToSides(world, pos, fluidState, blockState);
                }
            } else if (fluidState.isSource() || !this.isWaterHole((BlockGetter)world, newFluidState.getType(), pos, blockState, downPos, downBlockState)) {
                this.spreadToSides(world, pos, fluidState, blockState);
            }
        }
    }

    protected void spreadToSides(Level world, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int i = fluidState.getAmount() - this.getDropOff((LevelReader)world);
        if (i > 0) {
            Map<Direction, FluidState> map = this.getSpread(world, pos, blockState);
            for (Map.Entry<Direction, FluidState> entry : map.entrySet()) {
                BlockState offsetBlockState;
                Direction direction = entry.getKey();
                FluidState offsetFluidState = entry.getValue();
                BlockPos offsetPos = pos.relative(direction);
                if (!this.canSpreadTo((BlockGetter)world, pos, blockState, direction, offsetPos, offsetBlockState = world.getBlockState(offsetPos), world.getFluidState(offsetPos), offsetFluidState.getType())) continue;
                this.spreadTo((LevelAccessor)world, offsetPos, offsetBlockState, direction, offsetFluidState);
            }
        }
    }

    protected FluidState getNewLiquid(Level world, BlockPos pos, BlockState blockState) {
        BlockPos upPos;
        BlockState upBlockState;
        FluidState upFluidState;
        int i = 0;
        int j = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.relative(direction);
            BlockState offsetBlockState = world.getBlockState(offsetPos);
            FluidState offsetFluidState = offsetBlockState.getFluidState();
            if (!offsetFluidState.getType().isSame((Fluid)this) || !this.canPassThroughWall(direction, (BlockGetter)world, pos, blockState, offsetPos, offsetBlockState)) continue;
            if (offsetFluidState.isSource() && EventHooks.canCreateFluidSource((Level)world, (BlockPos)pos, (BlockState)blockState, (boolean)offsetFluidState.canConvertToSource(world, offsetPos))) {
                ++j;
            }
            i = Math.max(i, offsetFluidState.getAmount());
        }
        if (j >= 2) {
            BlockState blockstate1 = world.getBlockState(pos.below());
            FluidState FluidState1 = blockstate1.getFluidState();
            if (blockstate1.isSolid() || this.isSourceBlockOfThisType(FluidState1)) {
                return (FluidState)this.defaultFluidState().setValue((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
            }
        }
        if (!(upFluidState = (upBlockState = world.getBlockState(upPos = pos.above())).getFluidState()).isEmpty() && upFluidState.getType().isSame((Fluid)this) && this.canPassThroughWall(Direction.UP, (BlockGetter)world, pos, blockState, upPos, upBlockState)) {
            return (FluidState)this.defaultFluidState().setValue((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel + 1));
        }
        int k = i - this.getDropOff((LevelReader)world);
        if (k <= 0) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return (FluidState)this.defaultFluidState().setValue((Property)this.levelProperty, (Comparable)Integer.valueOf(k));
    }

    protected boolean canPassThroughWall(Direction direction, BlockGetter world, BlockPos fromPos, BlockState fromBlockState, BlockPos toPos, BlockState toBlockState) {
        VoxelShape toShape;
        VoxelShape fromShape;
        boolean flag;
        Block.BlockStatePairKey cacheKey;
        Object2ByteLinkedOpenHashMap<Block.BlockStatePairKey> cache = !fromBlockState.getBlock().hasDynamicShape() && !toBlockState.getBlock().hasDynamicShape() ? OCCLUSION_CACHE.get() : null;
        if (cache != null) {
            cacheKey = new Block.BlockStatePairKey(fromBlockState, toBlockState, direction);
            byte b0 = cache.getAndMoveToFirst((Object)cacheKey);
            if (b0 != 127) {
                return b0 != 0;
            }
        } else {
            cacheKey = null;
        }
        boolean bl = flag = !Shapes.mergedFaceOccludes((VoxelShape)(fromShape = fromBlockState.getCollisionShape(world, fromPos)), (VoxelShape)(toShape = toBlockState.getCollisionShape(world, toPos)), (Direction)direction);
        if (cache != null) {
            if (cache.size() == 200) {
                cache.removeLastByte();
            }
            cache.putAndMoveToFirst((Object)cacheKey, (byte)(flag ? 1 : 0));
        }
        return flag;
    }

    protected void spreadTo(LevelAccessor world, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (blockState.getBlock() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockState.getBlock()).placeLiquid(world, pos, blockState, fluidState);
        } else {
            if (!blockState.isAir()) {
                this.beforeDestroyingBlock(world, pos, blockState);
            }
            world.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    protected void beforeDestroyingBlock(LevelAccessor world, BlockPos pos, BlockState blockState) {
        BlockEntity tile = blockState.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)blockState, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tile);
    }

    protected static short getCacheKey(BlockPos pos, BlockPos otherPos) {
        int dx = otherPos.getX() - pos.getX();
        int dz = otherPos.getZ() - pos.getZ();
        return (short)((dx + 128 & 0xFF) << 8 | dz + 128 & 0xFF);
    }

    protected Map<Direction, FluidState> getSpread(Level world, BlockPos pos, BlockState blockState) {
        int i = 1000;
        EnumMap<Direction, FluidState> map = new EnumMap<Direction, FluidState>(Direction.class);
        Short2ObjectOpenHashMap stateMap = new Short2ObjectOpenHashMap();
        Short2BooleanOpenHashMap isWaterHoleMap = new Short2BooleanOpenHashMap();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.relative(direction);
            short key = PlaceableFluid.getCacheKey(pos, offsetPos);
            Pair offsetState = (Pair)stateMap.computeIfAbsent(key, k -> {
                BlockState offsetBlockState = world.getBlockState(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.getFluidState());
            });
            BlockState offsetBlockState = (BlockState)offsetState.getLeft();
            FluidState offsetFluidState = (FluidState)offsetState.getRight();
            FluidState newOffsetFluidState = this.getNewLiquid(world, offsetPos, offsetBlockState);
            if (!this.canFlowSource((BlockGetter)world, newOffsetFluidState.getType(), pos, blockState, direction, offsetPos, offsetBlockState, offsetFluidState)) continue;
            boolean flag = isWaterHoleMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.below();
                BlockState offsetDownState = world.getBlockState(offsetDownPos);
                return this.isWaterHole((BlockGetter)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            int j = 0;
            if (!flag) {
                j = this.getSlopeDistance((LevelReader)world, offsetPos, 1, direction.getOpposite(), offsetBlockState, pos, (Short2ObjectMap<Pair<BlockState, FluidState>>)stateMap, (Short2BooleanMap)isWaterHoleMap);
            }
            if (j < i) {
                map.clear();
            }
            if (j > i) continue;
            map.put(direction, newOffsetFluidState);
            i = j;
        }
        return map;
    }

    protected int getSlopeDistance(LevelReader world, BlockPos pos, int distance, Direction fromDirection, BlockState blockState, BlockPos startPos, Short2ObjectMap<Pair<BlockState, FluidState>> stateMap, Short2BooleanMap isWaterHoleMap) {
        int i = 1000;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int j;
            FluidState offsetFluidstate;
            short key;
            Pair pair;
            BlockState offsetBlockState;
            BlockPos offsetPos;
            if (direction == fromDirection || !this.canFlowSource((BlockGetter)world, this, pos, blockState, direction, offsetPos = pos.relative(direction), offsetBlockState = (BlockState)(pair = (Pair)stateMap.computeIfAbsent(key = PlaceableFluid.getCacheKey(startPos, offsetPos), k -> {
                BlockState offsetBlockState = world.getBlockState(offsetPos);
                return Pair.of((Object)offsetBlockState, (Object)offsetBlockState.getFluidState());
            })).getLeft(), offsetFluidstate = (FluidState)pair.getRight())) continue;
            boolean flag = isWaterHoleMap.computeIfAbsent(key, k -> {
                BlockPos offsetDownPos = offsetPos.below();
                BlockState offsetDownState = world.getBlockState(offsetDownPos);
                return this.isWaterHole((BlockGetter)world, this, offsetPos, offsetBlockState, offsetDownPos, offsetDownState);
            });
            if (flag) {
                return distance;
            }
            if (distance >= this.getSlopeFindDistance(world) || (j = this.getSlopeDistance(world, offsetPos, distance + 1, direction.getOpposite(), offsetBlockState, startPos, stateMap, isWaterHoleMap)) >= i) continue;
            i = j;
        }
        return i;
    }

    protected boolean isSourceBlockOfThisType(FluidState fluidState) {
        return fluidState.getType().isSame((Fluid)this) && fluidState.isSource();
    }

    protected int getSlopeFindDistance(LevelReader world) {
        return PlaceableFluid.ceilDiv(PlaceableFluid.ceilDiv(this.maxLevel, this.getDropOff(world)), 2);
    }

    protected int sourceNeighborCount(LevelReader world, BlockPos pos) {
        int count = 0;
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.relative(offset);
            FluidState offsetState = world.getFluidState(offsetPos);
            if (!this.isSourceBlockOfThisType(offsetState)) continue;
            ++count;
        }
        return count;
    }

    protected boolean canHoldFluid(BlockGetter world, BlockPos pos, BlockState blockState, Fluid fluid) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            return ((LiquidBlockContainer)block).canPlaceLiquid(null, world, pos, blockState, fluid);
        }
        if (block instanceof DoorBlock || blockState.is(BlockTags.SIGNS) || block == Blocks.LADDER || block == Blocks.SUGAR_CANE || block == Blocks.BUBBLE_COLUMN) {
            return false;
        }
        return !blockState.is(Blocks.NETHER_PORTAL) && !blockState.is(Blocks.END_PORTAL) && !blockState.is(Blocks.END_GATEWAY) && !blockState.is(Blocks.STRUCTURE_VOID) && !blockState.blocksMotion();
    }

    protected boolean canSpreadTo(BlockGetter world, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState, Fluid fluid) {
        return toFluidState.canBeReplacedWith(world, toPos, fluid, direction) && this.canPassThroughWall(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canHoldFluid(world, toPos, toBlockState, fluid);
    }

    protected boolean canFlowSource(BlockGetter world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, Direction direction, BlockPos toPos, BlockState toBlockState, FluidState toFluidState) {
        return !this.isSourceBlockOfThisType(toFluidState) && this.canPassThroughWall(direction, world, fromPos, fromBlockState, toPos, toBlockState) && this.canHoldFluid(world, toPos, toBlockState, fluid);
    }

    protected boolean isWaterHole(BlockGetter world, Fluid fluid, BlockPos fromPos, BlockState fromBlockState, BlockPos downPos, BlockState downState) {
        return this.canPassThroughWall(Direction.DOWN, world, fromPos, fromBlockState, downPos, downState) && (downState.getFluidState().getType().isSame((Fluid)this) || this.canHoldFluid(world, downPos, downState, fluid));
    }

    protected int getDelay(Level world, BlockPos pos, FluidState fluidState, FluidState newFluidState) {
        return this.getTickDelay((LevelReader)world);
    }

    public void tick(Level world, BlockPos pos, FluidState fluidState) {
        if (!fluidState.isSource()) {
            FluidState newFluidState = this.getNewLiquid(world, pos, world.getBlockState(pos));
            int delay = this.getDelay(world, pos, fluidState, newFluidState);
            if (newFluidState.isEmpty()) {
                fluidState = newFluidState;
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            } else if (!newFluidState.equals(fluidState)) {
                fluidState = newFluidState;
                BlockState blockState = fluidState.createLegacyBlock();
                world.setBlock(pos, blockState, 2);
                world.scheduleTick(pos, fluidState.getType(), delay);
                world.updateNeighborsAt(pos, blockState.getBlock());
            }
        }
        this.spread(world, pos, fluidState);
    }

    protected int getLegacyLevel(FluidState fluidState) {
        int level = (Integer)fluidState.getValue((Property)this.levelProperty);
        if (level > this.maxLevel) {
            return this.maxLevel;
        }
        return this.maxLevel - Math.min(fluidState.getAmount(), this.maxLevel);
    }

    protected static boolean hasSameAbove(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return fluidState.getType().isSame(world.getFluidState(pos.above()).getType());
    }

    public float getHeight(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return PlaceableFluid.hasSameAbove(fluidState, world, pos) ? 1.0f : fluidState.getOwnHeight();
    }

    public float getOwnHeight(FluidState fluidState) {
        return 0.9f * (float)fluidState.getAmount() / (float)this.maxLevel;
    }

    public boolean isSource(FluidState fluidState) {
        return (Integer)fluidState.getValue((Property)this.levelProperty) == this.maxLevel;
    }

    public int getAmount(FluidState fluidState) {
        return Math.min(this.maxLevel, (Integer)fluidState.getValue((Property)this.levelProperty));
    }

    public VoxelShape getShape(FluidState fluidState, BlockGetter world, BlockPos pos) {
        return this.shapeMap.computeIfAbsent(fluidState, s -> Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)s.getHeight(world, pos), (double)1.0));
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.ofNullable(this.getFluidType().getSound(SoundActions.BUCKET_FILL));
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) >= 0 && r * y != x) {
            ++r;
        }
        return r;
    }
}

