/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import thelm.jaopca.api.fluids.PlaceableFluid;

public abstract class PlaceableFluidBlock
extends Block
implements BucketPickup {
    protected final StateDefinition<Block, BlockState> stateDefinition;
    protected final PlaceableFluid fluid;
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluidBlock(BlockBehaviour.Properties properties, PlaceableFluid fluid, int maxLevel) {
        super(properties);
        this.fluid = fluid;
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.create((String)"level", (int)0, (int)maxLevel);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return blockState.getFluidState().isRandomlyTicking();
    }

    public void randomTick(BlockState blockState, ServerLevel world, BlockPos pos, RandomSource random) {
        world.getFluidState(pos).randomTick((Level)world, pos, random);
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public boolean isPathfindable(BlockState blockState, BlockGetter world, BlockPos pos, PathComputationType type) {
        return !this.fluid.is(FluidTags.LAVA);
    }

    public FluidState getFluidState(BlockState blockState) {
        IntegerProperty fluidLevelProperty = this.fluid.getLevelProperty();
        int blockLevel = (Integer)blockState.getValue((Property)this.levelProperty);
        int fluidLevel = blockLevel >= this.maxLevel ? this.maxLevel + 1 : this.maxLevel - blockLevel;
        return (FluidState)this.fluid.defaultFluidState().setValue((Property)fluidLevelProperty, (Comparable)Integer.valueOf(fluidLevel));
    }

    public boolean skipRendering(BlockState blockState, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getFluidState().getType().isSame((Fluid)this.fluid);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return List.of();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void onPlace(BlockState blockState, Level world, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (!FluidInteractionRegistry.canInteract((Level)world, (BlockPos)pos)) {
            world.scheduleTick(pos, blockState.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)world));
        }
    }

    public BlockState updateShape(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (blockState.getFluidState().isSource() || facingState.getFluidState().isSource()) {
            world.scheduleTick(currentPos, blockState.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)world));
        }
        return super.updateShape(blockState, facing, facingState, world, currentPos, facingPos);
    }

    public void neighborChanged(BlockState blockState, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!FluidInteractionRegistry.canInteract((Level)world, (BlockPos)pos)) {
            world.scheduleTick(pos, blockState.getFluidState().getType(), this.fluid.getTickDelay((LevelReader)world));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.levelProperty != null) {
            builder.add(new Property[]{this.levelProperty});
        }
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stateDefinition;
    }

    public ItemStack pickupBlock(Player player, LevelAccessor world, BlockPos pos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.levelProperty) == 0) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            return new ItemStack((ItemLike)this.fluid.getBucket());
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return this.fluid.getPickupSound();
    }
}

