/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialDoubleFunction
implements ToDoubleFunction<IMaterial> {
    public final double defaultValue;
    public final Object2DoubleMap<MaterialType> materialTypes;
    public final Object2DoubleMap<IMaterial> materials;
    public final String path;
    public final String comment;
    public final Object2DoubleMap<IMaterial> configMaterials;

    private MaterialDoubleFunction(double defaultValue, Object2DoubleMap<MaterialType> materialTypes, Object2DoubleMap<IMaterial> materials, String path, String comment) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
        this.path = Strings.nullToEmpty((String)path);
        this.comment = Strings.nullToEmpty((String)comment);
        this.configMaterials = !path.isEmpty() ? new Object2DoubleOpenHashMap() : Object2DoubleMaps.emptyMap();
    }

    public static MaterialDoubleFunction of(double defaultValue, Object2DoubleMap<MaterialType> materialTypes, Object2DoubleMap<IMaterial> materials, String path, String comment) {
        return new MaterialDoubleFunction(defaultValue, materialTypes, materials, path, comment);
    }

    public static MaterialDoubleFunction of(double defaultValue, Object2DoubleMap<MaterialType> materialTypes, Object2DoubleMap<IMaterial> materials) {
        return MaterialDoubleFunction.of(defaultValue, materialTypes, materials, "", "");
    }

    public static MaterialDoubleFunction of(double defaultValue, String path, String comment) {
        return MaterialDoubleFunction.of(defaultValue, (Object2DoubleMap<MaterialType>)Object2DoubleMaps.emptyMap(), (Object2DoubleMap<IMaterial>)Object2DoubleMaps.emptyMap(), path, comment);
    }

    public static MaterialDoubleFunction of(double defaultValue) {
        return MaterialDoubleFunction.of(defaultValue, (Object2DoubleMap<MaterialType>)Object2DoubleMaps.emptyMap(), (Object2DoubleMap<IMaterial>)Object2DoubleMaps.emptyMap(), "", "");
    }

    public static MaterialDoubleFunction of(double defaultValue, ToDoubleFunction<IMaterial> function) {
        if (function instanceof MaterialDoubleFunction) {
            MaterialDoubleFunction mf = (MaterialDoubleFunction)function;
            return MaterialDoubleFunction.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        Object2DoubleMap materialMap = (Object2DoubleMap)JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::applyAsDouble, (a, b) -> a, Object2DoubleOpenHashMap::new));
        return MaterialDoubleFunction.of(defaultValue, (Object2DoubleMap<MaterialType>)Object2DoubleMaps.emptyMap(), (Object2DoubleMap<IMaterial>)materialMap, "", "");
    }

    @Override
    public double applyAsDouble(IMaterial material) {
        if (!this.path.isEmpty()) {
            return this.configMaterials.computeIfAbsent((Object)material, m -> JAOPCAApi.instance().getMaterialConfig(material).getDefinedDouble(this.path, this.applyAsDoubleUnconfigured(material), this.comment));
        }
        return this.applyAsDoubleUnconfigured(material);
    }

    public double applyAsDoubleUnconfigured(IMaterial material) {
        if (this.materials.containsKey((Object)material)) {
            return this.materials.getDouble((Object)material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.getDouble((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials, this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialDoubleFunction) {
            MaterialDoubleFunction other = (MaterialDoubleFunction)obj;
            return this.defaultValue == other.defaultValue && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials) && this.path.equals(other.path);
        }
        return false;
    }
}

