/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.functions;

import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;

public final class MaterialLongFunction
implements ToLongFunction<IMaterial> {
    public final long defaultValue;
    public final Object2LongMap<MaterialType> materialTypes;
    public final Object2LongMap<IMaterial> materials;
    public final String path;
    public final String comment;
    public final Object2LongMap<IMaterial> configMaterials;

    private MaterialLongFunction(long defaultValue, Object2LongMap<MaterialType> materialTypes, Object2LongMap<IMaterial> materials, String path, String comment) {
        this.defaultValue = defaultValue;
        this.materialTypes = Objects.requireNonNull(materialTypes);
        this.materials = Objects.requireNonNull(materials);
        this.path = Strings.nullToEmpty((String)path);
        this.comment = Strings.nullToEmpty((String)comment);
        this.configMaterials = !path.isEmpty() ? new Object2LongOpenHashMap() : Object2LongMaps.emptyMap();
    }

    public static MaterialLongFunction of(long defaultValue, Object2LongMap<MaterialType> materialTypes, Object2LongMap<IMaterial> materials, String path, String comment) {
        return new MaterialLongFunction(defaultValue, materialTypes, materials, path, comment);
    }

    public static MaterialLongFunction of(long defaultValue, Object2LongMap<MaterialType> materialTypes, Object2LongMap<IMaterial> materials) {
        return MaterialLongFunction.of(defaultValue, materialTypes, materials, "", "");
    }

    public static MaterialLongFunction of(long defaultValue, String path, String comment) {
        return MaterialLongFunction.of(defaultValue, (Object2LongMap<MaterialType>)Object2LongMaps.emptyMap(), (Object2LongMap<IMaterial>)Object2LongMaps.emptyMap(), path, comment);
    }

    public static MaterialLongFunction of(long defaultValue) {
        return MaterialLongFunction.of(defaultValue, (Object2LongMap<MaterialType>)Object2LongMaps.emptyMap(), (Object2LongMap<IMaterial>)Object2LongMaps.emptyMap(), "", "");
    }

    public static MaterialLongFunction of(long defaultValue, ToLongFunction<IMaterial> function) {
        if (function instanceof MaterialLongFunction) {
            MaterialLongFunction mf = (MaterialLongFunction)function;
            return MaterialLongFunction.of(defaultValue, mf.materialTypes, mf.materials, mf.path, mf.comment);
        }
        Object2LongMap materialMap = (Object2LongMap)JAOPCAApi.instance().getMaterials().stream().collect(Collectors.toMap(Function.identity(), function::applyAsLong, (a, b) -> a, Object2LongOpenHashMap::new));
        return MaterialLongFunction.of(defaultValue, (Object2LongMap<MaterialType>)Object2LongMaps.emptyMap(), (Object2LongMap<IMaterial>)materialMap, "", "");
    }

    @Override
    public long applyAsLong(IMaterial material) {
        if (!this.path.isEmpty()) {
            return this.configMaterials.computeIfAbsent((Object)material, m -> JAOPCAApi.instance().getMaterialConfig(material).getDefinedLong(this.path, this.applyAsLongUnconfigured(material), this.comment));
        }
        return this.applyAsLongUnconfigured(material);
    }

    public long applyAsLongUnconfigured(IMaterial material) {
        if (this.materials.containsKey((Object)material)) {
            return this.materials.getLong((Object)material);
        }
        if (this.materialTypes.containsKey((Object)material.getType())) {
            return this.materialTypes.getLong((Object)material.getType());
        }
        return this.defaultValue;
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.materialTypes, this.materials, this.path);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MaterialLongFunction) {
            MaterialLongFunction other = (MaterialLongFunction)obj;
            return this.defaultValue == other.defaultValue && this.materialTypes.equals(other.materialTypes) && this.materials.equals(other.materials) && this.path.equals(other.path);
        }
        return false;
    }
}

