/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlock
extends Block
implements IMaterialFormBlock {
    private final IForm form;
    private final IMaterial material;
    protected final IBlockFormSettings settings;
    protected boolean blocksMovement;
    protected Supplier<MapColor> mapColor;
    protected Supplier<SoundType> soundType;
    protected IntSupplier lightOpacity;
    protected IntSupplier lightValue;
    protected DoubleSupplier explosionResistance;
    protected DoubleSupplier friction;
    protected VoxelShape shape;
    protected VoxelShape interactionShape;
    protected IntSupplier flammability;
    protected IntSupplier fireSpreadSpeed;
    protected BooleanSupplier isFireSource;
    protected Supplier<PushReaction> pushReaction;

    public JAOPCABlock(IForm form, IMaterial material, IBlockFormSettings settings) {
        super(JAOPCABlock.getProperties(form, material, settings));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.blocksMovement = settings.getBlocksMovement();
        this.mapColor = MemoizingSuppliers.of(settings.getMapColorFunction(), () -> material);
        this.soundType = MemoizingSuppliers.of(settings.getSoundTypeFunction(), () -> material);
        this.lightOpacity = MemoizingSuppliers.of(() -> settings.getLightOpacityFunction().applyAsInt(material));
        this.lightValue = MemoizingSuppliers.of(() -> settings.getLightValueFunction().applyAsInt(material));
        this.explosionResistance = MemoizingSuppliers.of(() -> settings.getExplosionResistanceFunction().applyAsDouble(material));
        this.friction = MemoizingSuppliers.of(() -> settings.getFrictionFunction().applyAsDouble(material));
        this.shape = settings.getShape();
        this.interactionShape = settings.getInteractionShape();
        this.flammability = MemoizingSuppliers.of(() -> settings.getFlammabilityFunction().applyAsInt(material));
        this.fireSpreadSpeed = MemoizingSuppliers.of(() -> settings.getFireSpreadSpeedFunction().applyAsInt(material));
        this.isFireSource = MemoizingSuppliers.of(() -> settings.getIsFireSourceFunction().test(material));
        this.pushReaction = MemoizingSuppliers.of(() -> settings.getPushReactionFunction().apply(material));
    }

    public static BlockBehaviour.Properties getProperties(IForm form, IMaterial material, IBlockFormSettings settings) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.of();
        prop.strength((float)settings.getBlockHardnessFunction().applyAsDouble(material));
        prop.lightLevel(state -> settings.getLightValueFunction().applyAsInt(material));
        if (settings.getReplaceable()) {
            prop.replaceable();
        }
        if (settings.getRequiresToolFunction().test(material)) {
            prop.requiresCorrectToolForDrops();
        }
        prop.instrument(settings.getInstrumentFunction().apply(material));
        prop.noOcclusion();
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return this.mapColor.get();
    }

    public SoundType getSoundType(BlockState blockState) {
        return this.soundType.get();
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return this.lightOpacity.getAsInt();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.lightValue.getAsInt();
    }

    public float getExplosionResistance() {
        return (float)this.explosionResistance.getAsDouble();
    }

    public float getFriction(BlockState blockState, LevelReader world, BlockPos pos, Entity entity) {
        return (float)this.friction.getAsDouble();
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.blocksMovement ? blockState.getShape(world, pos) : Shapes.empty();
    }

    public VoxelShape getInteractionShape(BlockState blockState, BlockGetter world, BlockPos pos) {
        return this.interactionShape;
    }

    public int getFlammability(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, LevelReader world, BlockPos pos, Direction side) {
        return this.isFireSource.getAsBoolean();
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return this.pushReaction.get();
    }

    public MutableComponent getName() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.form.getName(), this.material, this.getDescriptionId());
    }
}

