/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.blocks;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materialforms.IMaterialForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABlockItem
extends BlockItem
implements IMaterialFormBlockItem {
    protected final IBlockFormSettings settings;
    protected IntSupplier maxStackSize;
    protected BooleanSupplier hasEffect;
    protected Supplier<Rarity> rarity;
    protected IntSupplier burnTime;

    public JAOPCABlockItem(IMaterialFormBlock block, IBlockFormSettings settings) {
        super(block.toBlock(), new Item.Properties());
        this.settings = settings;
        this.maxStackSize = MemoizingSuppliers.of(settings.getMaxStackSizeFunction(), block::getMaterial);
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), block::getMaterial);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), block::getMaterial);
        this.burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), block::getMaterial);
    }

    @Override
    public IForm getForm() {
        return ((IMaterialForm)this.getBlock()).getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return ((IMaterialForm)this.getBlock()).getMaterial();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.maxStackSize.getAsInt();
    }

    public boolean isFoil(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.isFoil(stack);
    }

    public Rarity getRarity(ItemStack stack) {
        return this.rarity.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.burnTime.getAsInt();
    }

    public Component getName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("block.jaopca." + this.getForm().getName(), this.getMaterial(), this.getDescriptionId(stack));
    }
}

