/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.event.ModelEvent;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.MiscHelper;

public class ModelHandler {
    private static final FileToIdConverter BLOCK_MODEL_FORMAT = FileToIdConverter.json((String)"blockstates");
    private static final FileToIdConverter ITEM_MODEL_FORMAT = FileToIdConverter.json((String)"models/item");
    private static final Multimap<ResourceLocation, ResourceLocation> REMAPS = LinkedHashMultimap.create();

    public static void registerModels(ModelEvent.RegisterAdditional event) {
        ModelResourceLocation defaultModelLocation;
        ModelResourceLocation modelLocation;
        ResourceLocation location;
        for (IMaterialFormBlock materialFormBlock : BlockFormType.getBlocks()) {
            Block block = materialFormBlock.toBlock();
            location = BLOCK_MODEL_FORMAT.idToFile(BuiltInRegistries.BLOCK.getKey((Object)block));
            if (MiscHelper.INSTANCE.hasResource(location)) continue;
            block.getStateDefinition().getPossibleStates().forEach(state -> {
                String propertyMapString = BlockModelShaper.statePropertiesToString((Map)state.getValues());
                ModelResourceLocation modelLocation = new ModelResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)block), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca", materialFormBlock.getMaterial().getModelType() + "/" + materialFormBlock.getForm().getName(), propertyMapString);
                event.register((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBlockItem materialFormBlockItem : BlockFormType.getBlockItems()) {
            BlockItem blockItem = materialFormBlockItem.toBlockItem();
            location = ITEM_MODEL_FORMAT.idToFile(BuiltInRegistries.ITEM.getKey((Object)blockItem));
            if (MiscHelper.INSTANCE.hasResource(location)) continue;
            modelLocation = new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)blockItem), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca", materialFormBlockItem.getMaterial().getModelType() + "/" + materialFormBlockItem.getForm().getName(), "inventory");
            event.register((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormItem materialFormItem : ItemFormType.getItems()) {
            Item item = materialFormItem.toItem();
            location = ITEM_MODEL_FORMAT.idToFile(BuiltInRegistries.ITEM.getKey((Object)item));
            if (MiscHelper.INSTANCE.hasResource(location)) continue;
            modelLocation = new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)item), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca", materialFormItem.getMaterial().getModelType() + "/" + materialFormItem.getForm().getName(), "inventory");
            event.register((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormFluidBlock materialFormFluidBlock : FluidFormType.getFluidBlocks()) {
            Block fluidBlock = materialFormFluidBlock.toBlock();
            location = BLOCK_MODEL_FORMAT.idToFile(BuiltInRegistries.BLOCK.getKey((Object)fluidBlock));
            if (MiscHelper.INSTANCE.hasResource(location)) continue;
            fluidBlock.getStateDefinition().getPossibleStates().forEach(state -> {
                String propertyMapString = BlockModelShaper.statePropertiesToString((Map)state.getValues());
                ModelResourceLocation modelLocation = new ModelResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)fluidBlock), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca", materialFormFluidBlock.getMaterial().getModelType() + "/" + materialFormFluidBlock.getForm().getName(), propertyMapString);
                event.register((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBucketItem materialFormBucketItem : FluidFormType.getBucketItems()) {
            Item bucketItem = materialFormBucketItem.toItem();
            location = ITEM_MODEL_FORMAT.idToFile(BuiltInRegistries.ITEM.getKey((Object)bucketItem));
            if (MiscHelper.INSTANCE.hasResource(location)) continue;
            modelLocation = new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)bucketItem), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca", materialFormBucketItem.getMaterial().getModelType() + "/" + materialFormBucketItem.getForm().getName(), "inventory");
            event.register((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
    }

    public static void remapModels(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        BakedModel missingModel = (BakedModel)modelRegistry.get(ModelBakery.MISSING_MODEL_LOCATION);
        for (Map.Entry entry : REMAPS.asMap().entrySet()) {
            BakedModel defaultModel = modelRegistry.getOrDefault(entry.getKey(), missingModel);
            for (ResourceLocation modelLocation : (Collection)entry.getValue()) {
                modelRegistry.put(modelLocation, defaultModel);
            }
        }
    }
}

