/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.compat.crafttweaker.Module;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.Form")
public class Form {
    private static final TreeMap<IForm, Form> FORM_WRAPPERS = new TreeMap();
    private final IForm form;

    public static Form getFormWrapper(IForm form) {
        return FORM_WRAPPERS.computeIfAbsent(form, Form::new);
    }

    private Form(IForm form) {
        this.form = form;
    }

    public IForm getInternal() {
        return this.form;
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.form.getName();
    }

    @ZenCodeType.Getter(value="type")
    public String getType() {
        return this.form.getType().getName();
    }

    @ZenCodeType.Getter(value="module")
    public Module getModule() {
        return Module.getModuleWrapper(this.form.getModule());
    }

    @ZenCodeType.Getter(value="secondaryName")
    public String getSecondaryName() {
        return this.form.getSecondaryName();
    }

    @ZenCodeType.Getter(value="materialTypes")
    public String[] getMaterialTypes() {
        return (String[])this.form.getMaterialTypes().stream().map(MaterialType::getName).toArray(String[]::new);
    }

    @ZenCodeType.Getter(value="materials")
    public Material[] getMaterials() {
        return (Material[])this.form.getMaterials().stream().map(Material::getMaterialWrapper).toArray(Material[]::new);
    }

    @ZenCodeType.Getter(value="tagSeparator")
    public String getTagSeparator() {
        return this.form.getTagSeparator();
    }

    @ZenCodeType.Method
    public boolean containsMaterial(Material material) {
        return this.form.getMaterials().contains(material.getInternal());
    }

    @ZenCodeType.Method
    public MCTag getItemTag(String suffix) {
        return this.getTag(Registries.ITEM, suffix);
    }

    @ZenCodeType.Method
    public MCTag getFluidTag(String suffix) {
        return this.getTag(Registries.FLUID, suffix);
    }

    @ZenCodeType.Method
    public MCTag getTag(ResourceLocation registry, String suffix) {
        return this.getTag(ResourceKey.createRegistryKey((ResourceLocation)registry), suffix);
    }

    public <T> MCTag getTag(ResourceKey<? extends Registry<T>> registry, String suffix) {
        return this.getTag(CraftTweakerTagRegistry.INSTANCE.tagManager(registry), suffix);
    }

    @ZenCodeType.Method
    public MCTag getTag(ITagManager<?> tagManager, String suffix) {
        return tagManager.tag(MiscHelper.INSTANCE.getTagLocation(this.form.getSecondaryName(), suffix, this.form.getTagSeparator()));
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String suffix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(this.form.getSecondaryName(), suffix), count);
        return IItemStack.of((ItemStack)stack);
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String suffix) {
        return this.getItemStack(suffix, 1);
    }

    @ZenCodeType.Method
    public IFluidStack getFluidStack(String suffix, int amount) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getTagLocation(this.form.getSecondaryName(), suffix), amount);
        return IFluidStack.of((Object)stack);
    }

    @ZenCodeType.Method
    public MaterialForm getMaterialForm(Material material) {
        if (this.containsMaterial(material)) {
            return MaterialForm.getMaterialFormWrapper(this.form, material.getInternal());
        }
        return null;
    }

    @ZenCodeType.Getter(value="materialForms")
    public MaterialForm[] getMaterialForms() {
        return (MaterialForm[])this.form.getMaterials().stream().map(m -> MaterialForm.getMaterialFormWrapper(this.form, m)).toArray(MaterialForm[]::new);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Form) {
            Form other = (Form)obj;
            return this.form == other.form;
        }
        return false;
    }

    public int hashCode() {
        return this.form.hashCode() + 5;
    }
}

