/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import java.util.TreeMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.Material")
public class Material {
    private static final TreeMap<IMaterial, Material> MATERIAL_WRAPPERS = new TreeMap();
    private final IMaterial material;

    public static Material getMaterialWrapper(IMaterial material) {
        return MATERIAL_WRAPPERS.computeIfAbsent(material, Material::new);
    }

    private Material(IMaterial material) {
        this.material = material;
    }

    public IMaterial getInternal() {
        return this.material;
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.material.getName();
    }

    @ZenCodeType.Getter(value="type")
    public String getType() {
        return this.material.getType().getName();
    }

    @ZenCodeType.Getter(value="alternativeNames")
    public String[] getAlternativeNames() {
        return this.material.getAlternativeNames().toArray(new String[0]);
    }

    @ZenCodeType.Method
    public Material getExtra(int index) {
        return new Material(this.material.getExtra(index));
    }

    @ZenCodeType.Method
    public boolean hasExtra(int index) {
        return this.material.hasExtra(index);
    }

    @ZenCodeType.Getter(value="isSmallStorageBlock")
    public boolean isSmallStorageBlock() {
        return this.material.isSmallStorageBlock();
    }

    @ZenCodeType.Method
    public MCTag getItemTag(String prefix) {
        return this.getItemTag(prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getItemTag(String prefix, String tagSeperator) {
        return this.getTag(Registries.ITEM, prefix, tagSeperator);
    }

    @ZenCodeType.Method
    public MCTag getFluidTag(String prefix) {
        return this.getFluidTag(prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getFluidTag(String prefix, String tagSeperator) {
        return this.getTag(Registries.FLUID, prefix, tagSeperator);
    }

    @ZenCodeType.Method
    public MCTag getTag(ResourceLocation registry, String prefix) {
        return this.getTag(registry, prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getTag(ResourceLocation registry, String prefix, String tagSeperator) {
        return this.getTag(ResourceKey.createRegistryKey((ResourceLocation)registry), prefix, tagSeperator);
    }

    public <T> MCTag getTag(ResourceKey<? extends Registry<T>> registry, String prefix) {
        return this.getTag(registry, prefix, "/");
    }

    public <T> MCTag getTag(ResourceKey<? extends Registry<T>> registry, String prefix, String tagSeperator) {
        return this.getTag(CraftTweakerTagRegistry.INSTANCE.tagManager(registry), prefix, tagSeperator);
    }

    @ZenCodeType.Method
    public MCTag getTag(ITagManager<?> tagManager, String prefix) {
        return this.getTag(tagManager, prefix, "/");
    }

    @ZenCodeType.Method
    public MCTag getTag(ITagManager<?> tagManager, String prefix, String tagSeperator) {
        return tagManager.tag(MiscHelper.INSTANCE.getTagLocation(prefix, this.material.getName(), tagSeperator));
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return IItemStack.of((ItemStack)stack);
    }

    @ZenCodeType.Method
    public IItemStack getItemStack(String prefix) {
        return this.getItemStack(prefix, 1);
    }

    @ZenCodeType.Method
    public IFluidStack getFluidStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getTagLocation(prefix, this.material.getName()), count);
        return IFluidStack.of((Object)stack);
    }

    @ZenCodeType.Method
    public MaterialForm getMaterialForm(Form form) {
        if (form.containsMaterial(this)) {
            return MaterialForm.getMaterialFormWrapper(form.getInternal(), this.material);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Material) {
            Material other = (Material)obj;
            return this.material == other.material;
        }
        return false;
    }

    public int hashCode() {
        return this.material.hashCode() + 7;
    }
}

