/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.immersiveengineering.ImmersiveEngineeringHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"immersiveengineering"})
public class ImmersiveEngineeringCompatModule
implements IModule {
    private static final Set<String> GENERAL_BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "ardite", "brass", "bronze", "cobalt", "constantan", "copper", "electrum", "gold", "invar", "iron", "lead", "manyullyn", "nickel", "osmium", "platinum", "silver", "steel", "tin", "tungsten", "uranium", "zinc"));
    private static final Set<String> HAMMER_TO_PLATE_BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "constantan", "copper", "electrum", "gold", "iron", "lead", "nickel", "silver", "steel", "uranium"));
    private static final Set<String> WIRECUTTER_TO_WIRE_BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "copper", "electrum", "steel"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToIngotBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToRodBlacklist = new TreeSet<String>();
    private static Set<String> configToWireBlacklist = new TreeSet<String>();
    private static Set<String> configHammerToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configWirecutterToWireBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "immersiveengineering_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have crusher to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have arc furnace to ingot recipes added."), configToIngotBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to gear recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to rod recipes added."), configToRodBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toWireMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to wire recipes added."), configToWireBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.hammerToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have hammering recipes added."), configHammerToPlateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ImmersiveEngineeringHelper helper = ImmersiveEngineeringHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Item gearMold = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:mold_gear"));
        Item plateMold = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:mold_plate"));
        Item rodMold = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:mold_rod"));
        Item wireMold = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:mold_wire"));
        Item hammer = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:hammer"));
        Item wirecutter = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("immersiveengineering:wirecutter"));
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation wireLocation;
            ResourceLocation plateLocation;
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || GENERAL_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", name);
                if (itemTags.contains(dustLocation)) {
                    helper.registerCrusherRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_dust." + name), materialLocation, new Object[]{dustLocation, 1}, 3000);
                }
            }
            if (type.isIngot() && !GENERAL_BLACKLIST.contains(name) && !configToIngotBlacklist.contains(name)) {
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", name);
                ResourceLocation materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                if (itemTags.contains(dustLocation)) {
                    helper.registerArcFurnaceRecipe(new ResourceLocation("jaopca", "immersiveengineering.dust_to_material." + name), new Object[]{dustLocation, 1}, new Object[]{materialLocation2, 1}, 100, 51200);
                }
            }
            if (type.isIngot() && !GENERAL_BLACKLIST.contains(name) && !configToGearBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation gearLocation = miscHelper.getTagLocation("gears", name);
                if (itemTags.contains(gearLocation)) {
                    helper.registerMetalPressRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_gear." + name), materialLocation, 4, gearMold, gearLocation, 1, 2400);
                }
            }
            if (type.isIngot() && !GENERAL_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                plateLocation = miscHelper.getTagLocation("plates", name);
                if (itemTags.contains(plateLocation)) {
                    helper.registerMetalPressRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_plate." + name), materialLocation, 1, plateMold, plateLocation, 1, 2400);
                }
            }
            if (type.isIngot() && !GENERAL_BLACKLIST.contains(name) && !configToRodBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation rodLocation = miscHelper.getTagLocation("rods", name);
                if (itemTags.contains(rodLocation)) {
                    helper.registerMetalPressRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_rod." + name), materialLocation, 1, rodMold, rodLocation, 2, 2400);
                }
            }
            if (type.isIngot() && !GENERAL_BLACKLIST.contains(name) && !configToWireBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                wireLocation = miscHelper.getTagLocation("wires", name);
                if (itemTags.contains(wireLocation)) {
                    helper.registerMetalPressRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_wire." + name), materialLocation, 1, wireMold, wireLocation, 2, 2400);
                }
            }
            if (type.isIngot() && !HAMMER_TO_PLATE_BLACKLIST.contains(name) && !configHammerToPlateBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                plateLocation = miscHelper.getTagLocation("plates", name);
                if (itemTags.contains(plateLocation)) {
                    ((JAOPCAApi)api).registerShapelessRecipe(new ResourceLocation("jaopca", "immersiveengineering.material_to_plate_hammer." + name), plateLocation, 1, materialLocation, hammer);
                }
            }
            if (!type.isIngot() || WIRECUTTER_TO_WIRE_BLACKLIST.contains(name) || configWirecutterToWireBlacklist.contains(name)) continue;
            ResourceLocation plateLocation2 = miscHelper.getTagLocation("plates", name);
            wireLocation = miscHelper.getTagLocation("wires", name);
            if (!itemTags.contains(plateLocation2) || !itemTags.contains(wireLocation)) continue;
            ((JAOPCAApi)api).registerShapelessRecipe(new ResourceLocation("jaopca", "immersiveengineering.plate_to_wire." + name), wireLocation, 1, plateLocation2, wirecutter);
        }
    }
}

