/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CrusherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int energy;

    public CrusherRecipeSerializer(ResourceLocation key, Object input, Object[] output, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        TagOutput result = null;
        ArrayList<StackWithChance> secondary = new ArrayList<StackWithChance>();
        int i = 0;
        while (i < this.output.length) {
            Ingredient is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(out)) == null) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            if (result == null) {
                result = new TagOutput(new IngredientWithSize(is, count.intValue()));
                continue;
            }
            secondary.add(new StackWithChance(new TagOutput(new IngredientWithSize(is, count.intValue())), chance.floatValue(), new ICondition[0]));
        }
        if (result == null) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        CrusherRecipe recipe = new CrusherRecipe(result, ing, this.energy, secondary);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

