/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import com.google.common.collect.TreeBasedTable;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import thelm.jaopca.api.blocks.IBlockLike;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materialforms.IMaterialFormInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.Material;
import thelm.jaopca.utils.MiscHelper;

public class MaterialForm {
    private static final TreeBasedTable<IForm, IMaterial, MaterialForm> MATERIAL_FORM_WRAPPERS = TreeBasedTable.create();
    private final IMaterialFormInfo info;

    public static MaterialForm getMaterialFormWrapper(IForm form, IMaterial material) {
        MaterialForm materialForm = (MaterialForm)MATERIAL_FORM_WRAPPERS.get((Object)form, (Object)material);
        if (materialForm == null) {
            IMaterialFormInfo info = form.getType().getMaterialFormInfo(form, material);
            materialForm = new MaterialForm(info);
        }
        return materialForm;
    }

    private MaterialForm(IMaterialFormInfo info) {
        this.info = info;
    }

    public IMaterialFormInfo getInternal() {
        return this.info;
    }

    public Form getForm() {
        return Form.getFormWrapper(this.info.getMaterialForm().getForm());
    }

    public Material getMaterial() {
        return Material.getMaterialWrapper(this.info.getMaterialForm().getMaterial());
    }

    public String asTag() {
        return MiscHelper.INSTANCE.getTagLocation(this.info.getMaterialForm().getForm().getSecondaryName(), this.info.getMaterialForm().getMaterial().getName(), this.info.getMaterialForm().getForm().getTagSeparator()).toString();
    }

    public ItemStack asItemStack(int count) {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof ItemLike) {
            ItemLike item = (ItemLike)iMaterialFormInfo;
            return new ItemStack(item, count);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack asItemStack() {
        return this.asItemStack(1);
    }

    public FluidStackJS asFluidStack(int amount) {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)((Object)iMaterialFormInfo);
            return FluidStackJS.of((Object)fluid.asFluid(), (long)amount, null);
        }
        return EmptyFluidStackJS.INSTANCE;
    }

    public Block asBlock() {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IBlockLike) {
            IBlockLike block = (IBlockLike)((Object)iMaterialFormInfo);
            return block.asBlock();
        }
        return null;
    }

    public BlockState asBlockState() {
        IMaterialFormInfo iMaterialFormInfo = this.info;
        if (iMaterialFormInfo instanceof IBlockLike) {
            IBlockLike block = (IBlockLike)((Object)iMaterialFormInfo);
            return block.asBlock().defaultBlockState();
        }
        return null;
    }
}

