/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import com.google.gson.JsonElement;
import java.util.Objects;
import mekanism.api.recipes.basic.BasicPurifyingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.MiscHelper;

public class PurifyingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object gasInput;
    public final int gasInputAmount;
    public final Object output;
    public final int outputCount;

    public PurifyingRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object gasInput, int gasInputAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.gasInput = gasInput;
        this.gasInputAmount = gasInputAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        ItemStackIngredient ing = MekanismHelper.INSTANCE.getItemStackIngredient(this.itemInput, this.itemInputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        ChemicalStackIngredient.GasStackIngredient gasIng = MekanismHelper.INSTANCE.getGasStackIngredient(this.gasInput, this.gasInputAmount);
        if (gasIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.gasInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        BasicPurifyingRecipe recipe = new BasicPurifyingRecipe(ing, gasIng, stack);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

