/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import com.google.gson.JsonElement;
import java.util.Objects;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.basic.BasicFluidSlurryToSlurryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.MiscHelper;

public class WashingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object slurryInput;
    public final int slurryInputAmount;
    public final Object output;
    public final int outputCount;

    public WashingRecipeSerializer(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object slurryInput, int slurryInputAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.slurryInput = slurryInput;
        this.slurryInputAmount = slurryInputAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public JsonElement get() {
        FluidStackIngredient fluidIng = MekanismHelper.INSTANCE.getFluidStackIngredient(this.fluidInput, this.fluidInputAmount);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        ChemicalStackIngredient.SlurryStackIngredient slurryIng = MekanismHelper.INSTANCE.getSlurryStackIngredient(this.slurryInput, this.slurryInputAmount);
        if (slurryIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.slurryInput);
        }
        SlurryStack stack = MekanismHelper.INSTANCE.getSlurryStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        BasicFluidSlurryToSlurryRecipe recipe = new BasicFluidSlurryToSlurryRecipe(fluidIng, slurryIng, stack);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

