/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.modernindustrialization;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.modernindustrialization.ModernIndustrializationHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"modern_industrialization"})
public class ModernIndustrializationCrushedModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("bauxite", "coal", "diamond", "emerald", "lapis", "lignite_coal", "monazite", "quartz", "redstone", "salt"));
    private final IForm crushedDustForm = ApiImpl.INSTANCE.newForm(this, "modern_industrialization_crushed_dusts", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT_LEGACY, MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST).setSecondaryName("modern_industrialization:crushed_dusts").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "modern_industrialization_crushed";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return List.of(this.crushedDustForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT_LEGACY, MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ModernIndustrializationHelper helper = ModernIndustrializationHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            IItemInfo crushedDustInfo = itemFormType.getMaterialFormInfo(this.crushedDustForm, material);
            ResourceLocation crushedDustLocation = miscHelper.getTagLocation("modern_industrialization:crushed_dusts", material.getName());
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerMaceratorRecipe(new ResourceLocation("jaopca", "modern_industrialization.ore_to_crushed_dust." + material.getName()), oreLocation, 1, 1.0f, new Object[]{crushedDustInfo, 3, Float.valueOf(1.0f)}, 2, 200);
            helper.registerMaceratorRecipe(new ResourceLocation("jaopca", "modern_industrialization.crushed_dust_to_dust." + material.getName()), crushedDustLocation, 1, 1.0f, new Object[]{dustLocation, 1, Float.valueOf(1.0f), dustLocation, 1, Float.valueOf(0.5f)}, 2, 100);
        }
    }
}

