/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.modernindustrialization.recipes;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import com.google.gson.JsonElement;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.modernindustrialization.recipes.MIRecipeConstructor;
import thelm.jaopca.utils.MiscHelper;

public class CompressorRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final float inputChance;
    public final Object output;
    public final int outputCount;
    public final float outputChance;
    public final int eu;
    public final int duration;

    public CompressorRecipeSerializer(ResourceLocation key, Object input, int inputCount, float inputChance, Object output, int outputCount, float outputChance, int eu, int duration) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.inputChance = inputChance;
        this.output = output;
        this.outputCount = outputCount;
        this.outputChance = outputChance;
        this.eu = eu;
        this.duration = duration;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        MachineRecipe recipe = new MIRecipeConstructor(MIMachineRecipeTypes.COMPRESSOR, this.eu, this.duration).recipe();
        recipe.itemInputs.add(new MachineRecipe.ItemInput(ing, this.inputCount, this.inputChance));
        recipe.itemOutputs.add(new MachineRecipe.ItemOutput(stack.getItem(), this.outputCount, this.outputChance));
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

