/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.modernindustrialization.recipes;

import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerRecipe;
import com.google.gson.JsonElement;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class ForgeHammerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int hammerDamage;

    public ForgeHammerRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int hammerDamage) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.hammerDamage = hammerDamage;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ForgeHammerRecipe recipe = new ForgeHammerRecipe(ing, this.inputCount, stack, this.hammerDamage);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

