/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.modernindustrialization.recipes;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.modernindustrialization.recipes.MIRecipeConstructor;
import thelm.jaopca.utils.MiscHelper;

public class PackerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object output;
    public final int outputCount;
    public final float outputChance;
    public final int eu;
    public final int duration;

    public PackerRecipeSerializer(ResourceLocation key, Object[] input, Object output, int outputCount, float outputChance, int eu, int duration) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.outputChance = outputChance;
        this.eu = eu;
        this.duration = duration;
    }

    @Override
    public JsonElement get() {
        ArrayList<MachineRecipe.ItemInput> inputs = new ArrayList<MachineRecipe.ItemInput>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient ing;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                count = (Integer)this.input[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.input.length && this.input[i] instanceof Float) {
                chance = (Float)this.input[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            inputs.add(new MachineRecipe.ItemInput(ing, count.intValue(), chance.floatValue()));
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.deepToString(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        MachineRecipe recipe = new MIRecipeConstructor(MIMachineRecipeTypes.PACKER, this.eu, this.duration).recipe();
        recipe.itemInputs.addAll(inputs);
        recipe.itemOutputs.add(new MachineRecipe.ItemOutput(stack.getItem(), this.outputCount, this.outputChance));
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

