/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.modernindustrialization.recipes;

import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.modernindustrialization.recipes.MIRecipeConstructor;
import thelm.jaopca.utils.MiscHelper;

public class UnpackerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final float inputChance;
    public final Object[] output;
    public final int eu;
    public final int duration;

    public UnpackerRecipeSerializer(ResourceLocation key, Object input, int inputCount, float inputChance, Object[] output, int eu, int duration) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.inputChance = inputChance;
        this.output = output;
        this.eu = eu;
        this.duration = duration;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<MachineRecipe.ItemOutput> outputs = new ArrayList<MachineRecipe.ItemOutput>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getItemStack(out, count)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new MachineRecipe.ItemOutput(is.getItem(), count.intValue(), chance.floatValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        MachineRecipe recipe = new MIRecipeConstructor(MIMachineRecipeTypes.UNPACKER, this.eu, this.duration).recipe();
        recipe.itemInputs.add(new MachineRecipe.ItemInput(ing, this.inputCount, this.inputChance));
        recipe.itemOutputs.addAll(outputs);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

