/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.occultism;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.occultism.OccultismHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"occultism"})
public class OccultismModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iesnium", "iron", "silver"));

    @Override
    public String getName() {
        return "occultism";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        OccultismHelper helper = OccultismHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "occultism.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, 200, false);
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "occultism.raw_material_to_dust." + material.getName()), rawMaterialLocation, dustLocation, 2, 200, false);
        }
    }
}

