/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.openloader;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PathPackResources;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.resources.IPackSupplier;
import thelm.jaopca.api.resources.JAOPCAPackSupplier;

@JAOPCAPackSupplier(modDependencies={"openloader"})
public class OpenLoaderPackSupplier
implements IPackSupplier {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void addPacks(Consumer<PackResources> resourcePacks) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("openloader");
        ConfigSchema config = ConfigSchema.load((Path)configDir);
        if (config.dataPacks.enabled) {
            ArrayList<File> dirs = new ArrayList<File>();
            dirs.add(configDir.resolve(RepoType.DATA.getPath()).toFile());
            for (String customDir : config.dataPacks.additionalFolders) {
                dirs.add(new File(customDir));
            }
            for (File loaderDir : dirs) {
                if (!loaderDir.isDirectory()) {
                    LOGGER.error("Could not read from {} as it is not a directory.", (Object)loaderDir.getAbsolutePath());
                    continue;
                }
                try {
                    File[] files = loaderDir.listFiles();
                    if (files == null) {
                        LOGGER.error("Could not read from {}.", (Object)loaderDir.getAbsolutePath());
                        continue;
                    }
                    for (File file : files) {
                        boolean isPack;
                        boolean bl = isPack = OpenLoaderPackSupplier.isArchivePack(file, false) || OpenLoaderPackSupplier.isFolderPack(file, false);
                        if (isPack) {
                            resourcePacks.accept((PackResources)(file.isDirectory() ? new PathPackResources(file.getName(), file.toPath(), false) : new FilePackResources(file.getName(), new FilePackResources.SharedZipFileAccess(file), false, "")));
                            continue;
                        }
                        OpenLoaderPackSupplier.isArchivePack(file, true);
                        OpenLoaderPackSupplier.isFolderPack(file, true);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not read from {}.", (Object)loaderDir.getAbsolutePath(), (Object)e);
                }
            }
        }
    }

    private static boolean isArchivePack(File candidate, boolean logIssues) {
        if (candidate.isFile()) {
            boolean valid;
            String fileName = candidate.getName();
            boolean bl = valid = OpenLoaderPackSupplier.endsWithIgnoreCase(fileName, ".zip") || OpenLoaderPackSupplier.endsWithIgnoreCase(fileName, ".jar");
            if (!valid && logIssues) {
                LOGGER.warn("Can not load {} as an archive pack as it is not a .zip or .jar file.", (Object)candidate.getAbsolutePath());
            }
            return valid;
        }
        if (logIssues) {
            LOGGER.warn("Can not load {} as an archive pack as it is not a file.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean isFolderPack(File candidate, boolean logIssues) {
        if (candidate.isDirectory()) {
            boolean valid = new File(candidate, "pack.mcmeta").isFile();
            if (!valid && logIssues) {
                LOGGER.warn("Can not load {} as a folder pack as it is missing a pack.mcmeta file.", (Object)candidate.getAbsolutePath());
            }
            return valid;
        }
        if (logIssues) {
            LOGGER.warn("Can not load {} as a folder pack as it is not a directory.", (Object)candidate.getAbsolutePath());
        }
        return false;
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

