/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.items;

import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.theurgy.TheurgyModule;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAAlchemicalSulfurItem
extends AlchemicalSulfurItem
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;

    public JAOPCAAlchemicalSulfurItem(IForm form, IMaterial material, IItemFormSettings settings) {
        super(new Item.Properties());
        this.form = form;
        this.material = material;
        this.tier = TheurgyModule.TIER_FUNCTION.apply(material);
        this.type = switch (material.getType()) {
            case MaterialType.INGOT, MaterialType.INGOT_LEGACY -> AlchemicalSulfurType.METALS;
            case MaterialType.GEM, MaterialType.CRYSTAL -> AlchemicalSulfurType.GEMS;
            default -> AlchemicalSulfurType.OTHER_MINERALS;
        };
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void addToCreativeModeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("theurgy:sulfur.source.id", "#" + MiscHelper.INSTANCE.getTagLocation(this.material.getType().getFormName(), this.material.getName()));
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.setTag(nbt);
        output.accept(stack);
    }

    public MutableComponent getSourceName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("%s", this.material, "%s").withStyle(Style.EMPTY.withColor(this.tier.color()).withItalic(Boolean.valueOf(true)));
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.translatable((String)"item.jaopca.theurgy_alchemical_sulfurs.tooltip", (Object[])new Object[]{this.getSourceName(stack), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.tier.descriptionId()).withStyle(Style.EMPTY.withColor(this.tier.color).withItalic(Boolean.valueOf(true)))), ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)this.type.descriptionId()).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY).withItalic(Boolean.valueOf(true))))}).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"item.jaopca.theurgy_alchemical_sulfurs", (Object[])new Object[]{ComponentUtils.wrapInSquareBrackets((Component)this.getSourceName(stack))});
    }
}

