/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.recipes;

import com.google.gson.JsonElement;
import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.theurgy.TheurgyHelper;
import thelm.jaopca.utils.MiscHelper;

public class LiquefactionRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputCount;
    public final int time;

    public LiquefactionRecipeSerializer(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        FluidIngredient fluidIng = TheurgyHelper.INSTANCE.getFluidIngredient(this.fluidInput);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        CompoundTag nbt = new CompoundTag();
        if (this.itemInput instanceof String || this.itemInput instanceof ResourceLocation) {
            nbt.putString("theurgy:sulfur.source.id", "#" + this.itemInput.toString());
        } else {
            Object object = this.itemInput;
            if (object instanceof TagKey) {
                TagKey tag = (TagKey)object;
                nbt.putString("theurgy:sulfur.source.id", "#" + tag.location());
            } else {
                ItemStack inputStack = MiscHelper.INSTANCE.getItemStack(this.itemInput, 1);
                nbt.putString("theurgy:sulfur.source.id", BuiltInRegistries.ITEM.getKey((Object)inputStack.getItem()).toString());
            }
        }
        stack.setTag(nbt);
        LiquefactionRecipe recipe = new LiquefactionRecipe(ing, fluidIng, this.fluidInputAmount, stack, this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

