/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.usefulmachinery;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.usefulmachinery.UsefulMachineryHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"usefulmachinery"})
public class UsefulMachineryLegacyModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("aluminium", "aluminum", "copper", "gold", "iron", "lead", "nickel", "platinum", "silver", "tin", "uranium"));

    @Override
    public String getName() {
        return "usefulmachinery_legacy";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        UsefulMachineryHelper helper = UsefulMachineryHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            if (material.hasExtra(1)) {
                IMaterial extraMaterial = material.getExtra(1);
                ResourceLocation extraLocation = miscHelper.getTagLocation(extraMaterial.getType() == MaterialType.INGOT ? "raw_materials" : "dusts", extraMaterial.getName());
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "usefulmachinery.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, extraLocation, 1, 0.1f, 200, true, true);
                continue;
            }
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "usefulmachinery.ore_to_dust." + material.getName()), oreLocation, dustLocation, 2, 200, true, true);
        }
    }
}

