/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.data;

import com.google.common.base.Predicates;
import com.google.common.collect.TreeMultimap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagManager;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import thelm.jaopca.api.resources.IPackSupplier;
import thelm.jaopca.api.resources.JAOPCAPackSupplier;
import thelm.jaopca.utils.MiscHelper;

public class DataCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TAGS_PATH_LENGTH = "tags/".length();
    private static final FileToIdConverter TAG_FORMAT = FileToIdConverter.json((String)"tags");
    private static final FileToIdConverter RECIPE_FORMAT = FileToIdConverter.json((String)"recipe");
    private static final FileToIdConverter LOOT_TABLE_FORMAT = FileToIdConverter.json((String)"loot_table");
    private static final FileToIdConverter ADVANCEMENT_FORMAT = FileToIdConverter.json((String)"advancement");
    private static final Type JAOPCA_PACK_SUPPLIER = Type.getType(JAOPCAPackSupplier.class);
    private static final TreeMultimap<String, ResourceLocation> DEFINED_TAGS = TreeMultimap.create();
    private static final TreeSet<ResourceLocation> DEFINED_RECIPES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_LOOT_TABLES = new TreeSet();
    private static final TreeSet<ResourceLocation> DEFINED_ADVANCEMENTS = new TreeSet();

    private DataCollector() {
    }

    public static void collectData() {
        DEFINED_TAGS.clear();
        DEFINED_RECIPES.clear();
        DEFINED_ADVANCEMENTS.clear();
        ArrayList<VanillaPackResources> resourcePacks = new ArrayList<VanillaPackResources>();
        resourcePacks.add(ServerPacksSource.createVanillaPackSource());
        ModList.get().getModFiles().stream().map(mf -> ResourcePackLoader.createPackForMod((IModFileInfo)mf).openPrimary(mf.getFile().getFileName())).forEach(resourcePacks::add);
        List<ModFileScanData.AnnotationData> annotationData = ModList.get().getAllScanData().stream().flatMap(data -> data.getAnnotations().stream()).filter(data -> JAOPCA_PACK_SUPPLIER.equals((Object)data.annotationType())).toList();
        Predicate<String> modVersionNotLoaded = MiscHelper.INSTANCE.modVersionNotLoaded(LOGGER);
        Predicate<String> classNotExists = MiscHelper.INSTANCE::classNotExists;
        for (ModFileScanData.AnnotationData aData : annotationData) {
            List modDeps = (List)aData.annotationData().get("modDependencies");
            List classDeps = (List)aData.annotationData().get("classDependencies");
            String className = aData.clazz().getClassName();
            if (modDeps != null && modDeps.stream().filter(Predicates.notNull()).anyMatch(modVersionNotLoaded)) {
                LOGGER.info("Pack supplier {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            if (classDeps != null && classDeps.stream().filter(Predicates.notNull()).anyMatch(classNotExists)) {
                LOGGER.info("Pack supplier {} has missing class dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IPackSupplier supplier;
                Class<?> supplierClass = Class.forName(className);
                Class<IPackSupplier> supplierInstanceClass = supplierClass.asSubclass(IPackSupplier.class);
                try {
                    Method method = supplierClass.getMethod("getInstance", new Class[0]);
                    supplier = (IPackSupplier)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    supplier = supplierInstanceClass.newInstance();
                }
                supplier.addPacks(resourcePacks::add);
                LOGGER.debug("Loaded pack supplier {}", (Object)className);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load pack supplier {}", (Object)className, (Object)e);
            }
        }
        try (MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, resourcePacks);){
            for (ResourceLocation location : TAG_FORMAT.listMatchingResources((ResourceManager)resourceManager).keySet()) {
                location = TAG_FORMAT.fileToId(location);
                String namespace = location.getNamespace();
                String path = location.getPath();
                String[] split = path.split("/", 2);
                if (split.length == 2) {
                    String[] split0;
                    Object type = split[0];
                    if (ModList.get().isLoaded((String)type) && (split0 = split[1].split("/", 2)).length == 2) {
                        type = (String)type + "/" + split0[0];
                        path = split0[1];
                        DEFINED_TAGS.put(type, (Object)location.withPath(path));
                        continue;
                    }
                    path = split[1];
                    DEFINED_TAGS.put(type, (Object)location.withPath(path));
                    continue;
                }
                LOGGER.error("Tag {} in namespace {} has no type", (Object)path, (Object)namespace);
            }
            LOGGER.info("Found {} unique defined tags", (Object)DEFINED_TAGS.size());
            for (ResourceLocation location : resourceManager.listResources("recipes", name -> name.getPath().endsWith(".json")).keySet()) {
                if ((location = RECIPE_FORMAT.fileToId(location)).getPath().equals("_constants") || location.getPath().equals("_factories")) continue;
                DEFINED_RECIPES.add(location);
            }
            LOGGER.info("Found {} unique defined recipes", (Object)DEFINED_RECIPES.size());
            for (ResourceLocation location : LOOT_TABLE_FORMAT.listMatchingResources((ResourceManager)resourceManager).keySet()) {
                DEFINED_LOOT_TABLES.add(LOOT_TABLE_FORMAT.fileToId(location));
            }
            LOGGER.info("Found {} unique defined loot tables", (Object)DEFINED_LOOT_TABLES.size());
            for (ResourceLocation location : ADVANCEMENT_FORMAT.listMatchingResources((ResourceManager)resourceManager).keySet()) {
                DEFINED_ADVANCEMENTS.add(ADVANCEMENT_FORMAT.fileToId(location));
            }
            LOGGER.info("Found {} unique defined advancements", (Object)DEFINED_ADVANCEMENTS.size());
        }
    }

    public static Set<ResourceLocation> getDefinedTags(ResourceKey<? extends Registry<?>> registry) {
        return DataCollector.getDefinedTags(TagManager.getTagDir(registry).substring(TAGS_PATH_LENGTH));
    }

    public static Set<ResourceLocation> getDefinedTags(String type) {
        return DEFINED_TAGS.get((Object)type.replace(':', '/'));
    }

    public static Set<ResourceLocation> getDefinedRecipes() {
        return DEFINED_RECIPES;
    }

    public static Set<ResourceLocation> getDefinedLootTables() {
        return DEFINED_LOOT_TABLES;
    }

    public static Set<ResourceLocation> getDefinedAdvancements() {
        return DEFINED_ADVANCEMENTS;
    }
}

