/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.JAOPCAFluidHandlerItem;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCABucketItem
extends Item
implements IMaterialFormBucketItem,
DispensibleContainerItem {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;
    protected IntSupplier maxStackSize;
    protected BooleanSupplier hasEffect;
    protected Supplier<Rarity> rarity;
    protected IntSupplier burnTime;

    public JAOPCABucketItem(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(new Item.Properties().craftRemainder(Items.BUCKET));
        this.fluid = fluid;
        this.settings = settings;
        this.maxStackSize = MemoizingSuppliers.of(settings.getMaxStackSizeFunction(), fluid::getMaterial);
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), fluid::getMaterial);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), fluid::getMaterial);
        this.burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), fluid::getMaterial);
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.maxStackSize.getAsInt();
    }

    public boolean isFoil(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.isFoil(stack);
    }

    public Rarity getRarity(ItemStack stack) {
        return this.rarity.get();
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return this.burnTime.getAsInt();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        BlockHitResult blockHitResult;
        ItemStack stack = player.getItemInHand(hand);
        InteractionResultHolder ret = EventHooks.onBucketUse((Player)player, (Level)world, (ItemStack)stack, (HitResult)(blockHitResult = JAOPCABucketItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE)));
        if (ret != null) {
            return ret;
        }
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos resultPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos offsetPos = resultPos.relative(blockHitResult.getDirection());
        if (world.mayInteract(player, resultPos) && player.mayUseItemAt(offsetPos, direction, stack)) {
            BlockPos placePos;
            BlockState state = world.getBlockState(resultPos);
            BlockPos blockPos = placePos = this.canBlockContainFluid(player, world, resultPos, state) ? resultPos : offsetPos;
            if (this.emptyContents(player, world, placePos, blockHitResult)) {
                this.checkExtraContent(player, world, stack, placePos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, placePos, stack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)this.getEmptySuccessItem(stack, player), (boolean)world.isClientSide);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    protected ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        return !player.getAbilities().instabuild ? new ItemStack((ItemLike)Items.BUCKET) : stack;
    }

    public void checkExtraContent(Player player, Level world, ItemStack stack, BlockPos pos) {
    }

    public boolean emptyContents(Player player, Level world, BlockPos pos, BlockHitResult blockHitResult) {
        LiquidBlockContainer container;
        LiquidBlockContainer container2;
        boolean flag1;
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean flag = blockState.canBeReplaced(this.fluid.toFluid());
        boolean bl = flag1 = blockState.isAir() || flag || block instanceof LiquidBlockContainer && (container2 = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos, blockState, this.fluid.toFluid());
        if (!flag1) {
            return blockHitResult != null && this.emptyContents(player, world, blockHitResult.getBlockPos().relative(blockHitResult.getDirection()), null);
        }
        FluidStack stack = new FluidStack(this.fluid.toFluid(), 1000);
        if (this.fluid.toFluid().getFluidType().isVaporizedOnPlacement(world, pos, stack)) {
            this.fluid.toFluid().getFluidType().onVaporize(player, world, pos, stack);
            return true;
        }
        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, pos, blockState, this.fluid.toFluid())) {
            container.placeLiquid((LevelAccessor)world, pos, blockState, this.fluid.toFluid().defaultFluidState());
            this.playEmptySound(player, (LevelAccessor)world, pos);
            return true;
        }
        if (!world.isClientSide && flag && !blockState.liquid()) {
            world.destroyBlock(pos, true);
        }
        if (!world.setBlock(pos, this.fluid.toFluid().getFluidType().getStateForPlacement((BlockAndTintGetter)world, pos, stack).createLegacyBlock(), 11) && !blockState.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)world, pos);
        return true;
    }

    protected void playEmptySound(Player player, LevelAccessor world, BlockPos pos) {
        SoundEvent soundEvent = this.fluid.toFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY);
        if (soundEvent == null) {
            soundEvent = this.fluid.toFluid().is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        world.playSound(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.gameEvent((Entity)player, GameEvent.FLUID_PLACE, pos);
    }

    protected boolean canBlockContainFluid(Player player, Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid(player, (BlockGetter)worldIn, posIn, blockstate, this.fluid.toFluid());
    }

    @Override
    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new JAOPCAFluidHandlerItem(this.fluid, (ItemStack)stack), new ItemLike[]{this});
    }

    public Component getName(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.getForm().getName(), this.getMaterial(), this.getDescriptionId(stack));
    }
}

