/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;

public class JAOPCAFluidHandlerItem
implements IFluidHandlerItem {
    protected final IMaterialFormFluid fluid;
    protected ItemStack container;

    public JAOPCAFluidHandlerItem(IMaterialFormFluid fluid, ItemStack container) {
        this.fluid = fluid;
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        return new FluidStack(this.fluid.toFluid(), 1000);
    }

    protected void clearFluid() {
        this.container = new ItemStack((ItemLike)Items.BUCKET);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.clearFluid();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < 1000) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.clearFluid();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

