/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import com.google.common.collect.ImmutableSortedMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.localization.LocalizationHandler;
import thelm.jaopca.utils.MiscHelper;

public class LocalizationRepoHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static Path configDir;
    private static Path langDir;
    private static Map<String, String> currentLocalizationMap;

    private LocalizationRepoHandler() {
    }

    public static void setup() {
        configDir = FMLPaths.CONFIGDIR.get().resolve("jaopca");
        langDir = configDir.resolve("lang");
        if (!Files.exists(langDir, new LinkOption[0]) || !Files.isDirectory(langDir, new LinkOption[0])) {
            try {
                if (Files.exists(langDir, new LinkOption[0]) && !Files.isDirectory(langDir, new LinkOption[0])) {
                    LOGGER.warn("Directory {} is a file, deleting", (Object)langDir);
                    Files.delete(langDir);
                }
                Files.createDirectory(langDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create directory " + langDir + ", please create manually", e);
            }
        }
        LocalizationRepoHandler.reload();
    }

    public static void reload() {
        MiscHelper.INSTANCE.submitAsyncTask(() -> {
            String language = LocalizationHandler.getLanguage();
            Path langFile = langDir.resolve(language + ".json");
            if (ConfigHandler.checkL10nUpdates) {
                try {
                    if (!Files.exists(langFile, new LinkOption[0]) || (double)(System.currentTimeMillis() - Files.getLastModifiedTime(langFile, new LinkOption[0]).toMillis()) > ConfigHandler.updateInterval * 24.0 * 3600.0 * 1000.0) {
                        LOGGER.info("Downloading localization file for language {}", (Object)language);
                        URL url = new URL("https://raw.githubusercontent.com/TheLMiffy1111/JAOPCAMaterialLocalizations/v3/lang/" + language + ".json");
                        InputStream con = LocalizationRepoHandler.openUrlStream(url);
                        Files.copy(con, langFile, StandardCopyOption.REPLACE_EXISTING);
                        LOGGER.info("Downloaded localization file for language {}", (Object)language);
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Unable to download localization file for language {}", (Object)language, (Object)e);
                    currentLocalizationMap = ImmutableSortedMap.of();
                }
            }
            if (Files.exists(langFile, new LinkOption[0])) {
                try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(langFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                    LOGGER.info("Reading localization file", (Object)language);
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    JsonObject json = jsonElement.getAsJsonObject();
                    ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                    for (Map.Entry entry : json.entrySet()) {
                        String string;
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (string = ((JsonElement)entry.getValue()).getAsString()).isEmpty()) continue;
                        builder.put((Object)((String)entry.getKey()), (Object)string);
                    }
                    currentLocalizationMap = builder.build();
                    LOGGER.info("Finished reading localization file", (Object)language);
                }
                catch (Exception e) {
                    LOGGER.info("Unable to read localization file", (Throwable)e);
                    currentLocalizationMap = ImmutableSortedMap.of();
                }
            }
        });
    }

    public static Map<String, String> getCurrentLocalizationMap() {
        return currentLocalizationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream openUrlStream(URL url) throws IOException {
        URL currentUrl = url;
        for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
            URLConnection c = currentUrl.openConnection();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)c;
                huc.setInstanceFollowRedirects(false);
                int responseCode = huc.getResponseCode();
                if (responseCode >= 300 && responseCode <= 399) {
                    try {
                        String loc = huc.getHeaderField("Location");
                        currentUrl = new URL(currentUrl, loc);
                        continue;
                    }
                    finally {
                        huc.disconnect();
                    }
                }
            }
            return c.getInputStream();
        }
        throw new IOException("Too many redirects while trying to fetch " + url);
    }

    static {
        currentLocalizationMap = ImmutableSortedMap.of();
    }
}

