/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class ShapedRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final CraftingBookCategory category;
    public final Object output;
    public final int count;
    public final Object[] input;

    public ShapedRecipeSerializer(ResourceLocation key, Object output, int count, Object ... input) {
        this(key, "", CraftingBookCategory.MISC, output, count, input);
    }

    public ShapedRecipeSerializer(ResourceLocation key, String group, Object output, int count, Object ... input) {
        this(key, group, CraftingBookCategory.MISC, output, count, input);
    }

    public ShapedRecipeSerializer(ResourceLocation key, CraftingBookCategory category, Object output, int count, Object ... input) {
        this(key, "", category, output, count, input);
    }

    public ShapedRecipeSerializer(ResourceLocation key, String group, CraftingBookCategory category, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.category = Objects.requireNonNull(category);
        this.output = output;
        this.count = count;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public JsonElement get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ArrayList<String> pattern = new ArrayList<String>();
        int idx = 0;
        if (this.input[idx] instanceof String[]) {
            String[] parts;
            for (String s : parts = (String[])this.input[idx++]) {
                if (!pattern.isEmpty() && s.length() != ((String)pattern.get(0)).length()) {
                    throw new IllegalArgumentException("Invalid pattern in recipe " + this.key + "Pattern must be the same width on every line");
                }
                pattern.add(s);
            }
        } else {
            while (this.input[idx] instanceof String) {
                String s = (String)this.input[idx++];
                pattern.add(s);
            }
        }
        HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
        while (idx < this.input.length) {
            Character chr = (Character)this.input[idx];
            Object in = this.input[idx + 1];
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (keyMap.containsKey(chr)) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + this.key + ": Symbol '" + chr + "' is defined twice");
            }
            if (' ' == chr.charValue()) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + this.key + ": Symbol ' ' is reserved");
            }
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            keyMap.put(chr, ing);
            idx += 2;
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("No pattern is defined for shaped recipe " + this.key);
        }
        HashSet set = new HashSet(keyMap.keySet());
        for (String str : pattern) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!keyMap.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalArgumentException("Pattern in recipe " + this.key + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalArgumentException("Ingredients are defined but not used in pattern for recipe " + this.key);
        }
        ShapedRecipe recipe = new ShapedRecipe(this.group, this.category, ShapedRecipePattern.of(keyMap, pattern), stack);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

