/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.utils;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeMultiset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.ingredients.WrappedIngredient;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "JAOPCA Executor Thread"));
    private TagManager tagManager;
    private List<TagManager.LoadResult<?>> lastTagResults = List.of();
    private Map<ResourceKey<? extends Registry<?>>, SetMultimap<ResourceLocation, Object>> tagMap = new TreeMap();
    private static final Comparator<Fluid> FLOWING_FLUID_COMPARATOR = (fluid1, fluid2) -> {
        FlowingFluid fFluid;
        FlowingFluid fFluid2;
        boolean flag1 = fluid1 instanceof FlowingFluid && (fFluid2 = (FlowingFluid)fluid1) == fFluid2.getFlowing();
        boolean flag2 = fluid2 instanceof FlowingFluid && (fFluid = (FlowingFluid)fluid2) == fFluid.getFlowing();
        return Boolean.compare(flag1, flag2);
    };
    private static final Predicate<String> CONFIG_MATERIAL_PREDICATE = s -> s.equals("*") || s.startsWith("*") && MaterialType.fromName(s.substring(1)) != null || MaterialHandler.containsMaterial(s);
    private static final Predicate<String> CONFIG_MODULE_PREDICATE = s -> s.equals("*") || ModuleHandler.getModuleMap().containsKey(s);

    private MiscHelper() {
    }

    public void setTagManager(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    @Override
    public ResourceLocation createResourceLocation(String location, String defaultNamespace) {
        if (StringUtils.contains((CharSequence)location, (int)58)) {
            return new ResourceLocation(location);
        }
        return new ResourceLocation(defaultNamespace, location);
    }

    @Override
    public ResourceLocation createResourceLocation(String location) {
        return this.createResourceLocation(location, "forge");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material) {
        return this.getTagLocation(form, material, "/");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material, String separator) {
        return this.createResourceLocation(form + (String)(StringUtils.isEmpty((CharSequence)material) ? "" : (StringUtils.isEmpty((CharSequence)separator) ? "/" : separator) + material));
    }

    @Override
    public ItemStack getItemStack(Object obj, int count) {
        ItemStack ret = this.getPreferredItemStack((Iterable)this.getIngredientResolved(obj).getRight(), count);
        return ret.isEmpty() ? ItemStack.EMPTY : ret;
    }

    @Override
    public Ingredient getIngredient(Object obj) {
        return (Ingredient)this.getIngredientResolved(obj).getLeft();
    }

    public Pair<Ingredient, Set<Item>> getIngredientResolved(Object obj) {
        Ingredient ing = null;
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        if (obj instanceof Supplier) {
            Pair<Ingredient, Set<Item>> pair = this.getIngredientResolved(((Supplier)obj).get());
            ing = (Ingredient)pair.getLeft();
            items.addAll((Collection)pair.getRight());
        } else if (obj instanceof CompoundIngredientObject) {
            CompoundIngredientObject cObj = (CompoundIngredientObject)obj;
            List<Pair> ings = Arrays.stream(cObj.ingredients()).map(this::getIngredientResolved).toList();
            if (ings.size() == 1) {
                Pair pair = ings.get(0);
                ing = (Ingredient)pair.getLeft();
                items.addAll((Collection)pair.getRight());
            } else if (ings.size() > 1) {
                switch (cObj.type()) {
                    case UNION: {
                        if (ings.stream().allMatch(p -> ((Set)p.getRight()).isEmpty())) break;
                        ing = CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().filter(p -> !((Set)p.getRight()).isEmpty()).map(Pair::getLeft).toArray(Ingredient[]::new)));
                        items.addAll(ings.stream().map(Pair::getRight).reduce(new HashSet(), (s1, s2) -> {
                            s1.addAll(s2);
                            return s1;
                        }));
                        break;
                    }
                    case INTERSECTION: {
                        if (ings.stream().anyMatch(p -> ((Set)p.getRight()).isEmpty())) break;
                        ing = IntersectionIngredient.of((Ingredient[])((Ingredient[])ings.stream().map(Pair::getLeft).toArray(Ingredient[]::new)));
                        items.addAll(ings.stream().map(Pair::getRight).reduce(Sets.newHashSet((Iterable)BuiltInRegistries.ITEM), (s1, s2) -> {
                            s1.retainAll((Collection<?>)s2);
                            return s1;
                        }));
                        break;
                    }
                    case DIFFERENCE: {
                        Pair firstPair = ings.get(0);
                        if (((Set)firstPair.getRight()).isEmpty()) break;
                        ing = DifferenceIngredient.of((Ingredient)((Ingredient)firstPair.getLeft()), (Ingredient)CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().skip(1L).filter(p -> !((Set)p.getRight()).isEmpty()).map(Pair::getLeft).toArray(Ingredient[]::new))));
                        items.addAll((Collection)firstPair.getRight());
                        items.removeAll(ings.stream().skip(1L).map(Pair::getRight).reduce(new HashSet(), (s1, s2) -> {
                            s1.addAll(s2);
                            return s1;
                        }));
                    }
                }
            }
        } else if (obj instanceof Ingredient) {
            ing = (Ingredient)obj;
            BuiltInRegistries.ITEM.forEach(items::add);
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = Ingredient.of(this.getItemTagKey(location));
            items.addAll(this.getItemTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = Ingredient.of(this.getItemTagKey(location));
            items.addAll(this.getItemTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = Ingredient.of((TagKey)key);
            items.addAll(this.getItemTagValues(key.location()));
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.isEmpty()) {
                ing = Ingredient.of((ItemStack[])new ItemStack[]{stack});
                items.add(stack.getItem());
            }
        } else if (obj instanceof ItemStack[]) {
            ItemStack[] stacks = (ItemStack[])obj;
            List<ItemStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = Ingredient.of(nonEmpty.stream());
                nonEmpty.stream().map(ItemStack::getItem).forEach(items::add);
            }
        } else if (obj instanceof ItemLike) {
            ItemLike item = (ItemLike)obj;
            if (item.asItem() != Items.AIR) {
                ing = Ingredient.of((ItemLike[])new ItemLike[]{item});
                items.add(item.asItem());
            }
        } else if (obj instanceof ItemLike[]) {
            ItemLike[] itemz = (ItemLike[])obj;
            List<Item> nonEmpty = Arrays.stream(itemz).map(ItemLike::asItem).filter(i -> i != Items.AIR).toList();
            if (!nonEmpty.isEmpty()) {
                ing = Ingredient.of((ItemLike[])((ItemLike[])nonEmpty.toArray(Item[]::new)));
                items.addAll(nonEmpty);
            }
        } else if (obj instanceof Ingredient.Value) {
            ing = Ingredient.fromValues(Stream.of((Ingredient.Value)obj));
            BuiltInRegistries.ITEM.forEach(items::add);
        } else if (obj instanceof Ingredient.Value[]) {
            ing = Ingredient.fromValues(Stream.of((Ingredient.Value[])obj));
            BuiltInRegistries.ITEM.forEach(items::add);
        } else if (obj instanceof JsonElement) {
            ing = Ingredient.fromJson((JsonElement)((JsonElement)obj), (boolean)true);
            BuiltInRegistries.ITEM.forEach(items::add);
        }
        items.remove(Items.AIR);
        return Pair.of((Object)(items.isEmpty() ? null : ing), items);
    }

    @Override
    public TagKey<Item> getItemTagKey(ResourceLocation location) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }

    @Override
    public Collection<Item> getItemTagValues(ResourceLocation location) {
        return this.getTagValues(Registries.ITEM, location);
    }

    @Override
    public ItemStack getPreferredItemStack(Iterable<Item> iterable, int count) {
        return new ItemStack((ItemLike)this.getPreferredEntry(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0), iterable).orElse(Items.AIR), count);
    }

    @Override
    public FluidStack getFluidStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getFluidStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                return stack;
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.EMPTY) {
                return new FluidStack(fluid, amount);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.EMPTY) {
                return new FluidStack(fluid.asFluid(), amount);
            }
        } else {
            if (obj instanceof String) {
                return this.getPreferredFluidStack(this.getFluidTagValues(new ResourceLocation((String)obj)), amount);
            }
            if (obj instanceof ResourceLocation) {
                return this.getPreferredFluidStack(this.getFluidTagValues((ResourceLocation)obj), amount);
            }
            if (obj instanceof TagKey) {
                return this.getPreferredFluidStack(this.getFluidTagValues(((TagKey)obj).location()), amount);
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public TagKey<Fluid> getFluidTagKey(ResourceLocation location) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)location);
    }

    @Override
    public Collection<Fluid> getFluidTagValues(ResourceLocation location) {
        return this.getTagValues(Registries.FLUID, location);
    }

    @Override
    public FluidStack getPreferredFluidStack(Iterable<Fluid> iterable, int amount) {
        return new FluidStack(this.getPreferredEntry(this.flowingFluidComparator(), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0), iterable).orElse(Fluids.EMPTY), amount);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceKey<? extends Registry<T>> registry, ResourceLocation location) {
        if (this.tagManager == null) {
            throw new IllegalStateException("Tag manager not initialized.");
        }
        if (this.tagManager.getResult() != this.lastTagResults) {
            this.lastTagResults = this.tagManager.getResult();
            this.tagMap.clear();
            if (this.lastTagResults.isEmpty()) {
                throw new IllegalStateException("Tags have not been loaded yet.");
            }
            this.lastTagResults.forEach(result -> {
                SetMultimap map = this.tagMap.computeIfAbsent(result.key(), k -> MultimapBuilder.treeKeys().linkedHashSetValues().build());
                result.tags().forEach((loc, tag) -> tag.forEach(holder -> map.put(loc, holder.value())));
            });
        }
        return Collections2.transform((Collection)this.tagMap.getOrDefault(registry, (SetMultimap<ResourceLocation, Object>)ImmutableSetMultimap.of()).asMap().getOrDefault(location, Set.of()), o -> o);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceLocation registry, ResourceLocation location) {
        return this.getTagValues(ResourceKey.createRegistryKey((ResourceLocation)registry), location);
    }

    @Override
    public <T> Optional<T> getPreferredEntry(Function<T, ResourceLocation> keyGetter, Iterable<T> iterable) {
        return Streams.stream(iterable).min(this.entryPreferenceComparator(keyGetter));
    }

    @Override
    public <T> Optional<T> getPreferredEntry(Comparator<T> comparator, Function<T, ResourceLocation> keyGetter, Iterable<T> iterable) {
        return Streams.stream(iterable).min(comparator.thenComparing(this.entryPreferenceComparator(keyGetter)));
    }

    @Override
    public <T> Comparator<T> entryPreferenceComparator(Function<T, ResourceLocation> keyGetter) {
        return (entry1, entry2) -> {
            int index2;
            ResourceLocation key2;
            ResourceLocation key1 = (ResourceLocation)keyGetter.apply(entry1);
            if (key1 == (key2 = (ResourceLocation)keyGetter.apply(entry2))) {
                return 0;
            }
            if (key1 == null) {
                return 1;
            }
            if (key2 == null) {
                return -1;
            }
            int index1 = ConfigHandler.PREFERRED_MODS.indexOf(key1.getNamespace());
            if (index1 == (index2 = ConfigHandler.PREFERRED_MODS.indexOf(key2.getNamespace()))) {
                return 0;
            }
            if (index1 == -1) {
                return 1;
            }
            if (index2 == -1) {
                return -1;
            }
            return Integer.compare(index1, index2);
        };
    }

    @Override
    public Comparator<Fluid> flowingFluidComparator() {
        return FLOWING_FLUID_COMPARATOR;
    }

    @Override
    public void caclulateMaterialSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = configList.stream().map(s -> s.startsWith("*") ? s.toLowerCase(Locale.US) : s).collect(Collectors.toCollection(TreeMultiset::create));
        int listCount = list.count((Object)"*");
        MaterialHandler.getMaterials().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        for (MaterialType type : MaterialType.values()) {
            int listCount1 = list.count((Object)("*" + type.getName()));
            MaterialHandler.getMaterials().stream().filter(m -> m.getType() == type).forEach(m -> list.add((Object)m.getName(), listCount1));
            list.remove((Object)("*" + type.getName()), listCount1);
        }
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public void caclulateModuleSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        ModuleHandler.getModules().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public Ingredient wrapIngredient(Ingredient ing) {
        return WrappedIngredient.of(ing);
    }

    @Override
    public JsonElement serializeIngredient(Ingredient ing) {
        return this.serialize(Ingredient.CODEC, ing);
    }

    @Override
    public JsonObject serializeItemStack(ItemStack stack) {
        return this.serialize(ItemStack.ITEM_WITH_COUNT_CODEC, stack).getAsJsonObject();
    }

    @Override
    public JsonObject serializeFluidStack(FluidStack stack) {
        return this.serialize(FluidStack.CODEC, stack).getAsJsonObject();
    }

    @Override
    public JsonElement serializeRecipe(Recipe<?> recipe) {
        return this.serialize(Recipe.CODEC, recipe);
    }

    @Override
    public <T> JsonElement serialize(Codec<T> codec, T obj) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).get();
    }

    @Override
    public Predicate<String> configMaterialPredicate() {
        return CONFIG_MATERIAL_PREDICATE;
    }

    @Override
    public Predicate<String> configModulePredicate() {
        return CONFIG_MODULE_PREDICATE;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    @Override
    public boolean hasResource(ResourceLocation location) {
        return (Boolean)this.conditionalSupplier(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> Minecraft.getInstance().getResourceManager().getResource(location).isPresent(), () -> () -> false).get();
    }

    public <T> Future<T> submitAsyncTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submitAsyncTask(Runnable task) {
        return this.executor.submit(task);
    }

    public int squareColorDifference(int color1, int color2) {
        int diffR = (color1 << 16 & 0xFF) - (color2 << 16 & 0xFF);
        int diffG = (color1 << 8 & 0xFF) - (color2 << 8 & 0xFF);
        int diffB = (color1 & 0xFF) - (color2 & 0xFF);
        return diffR * diffR + diffG * diffG + diffB * diffB;
    }

    public Predicate<String> modVersionNotLoaded(Logger logger) {
        return dep -> {
            VersionRange versionRange;
            ModList modList = ModList.get();
            int separatorIndex = dep.lastIndexOf(64);
            String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
            String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1);
            try {
                versionRange = VersionRange.createFromVersionSpec((String)spec);
            }
            catch (InvalidVersionSpecificationException e) {
                logger.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
                return true;
            }
            if (modList.isLoaded(modId)) {
                ArtifactVersion version = ((ModContainer)modList.getModContainerById(modId).get()).getModInfo().getVersion();
                if (versionRange.containsVersion(version)) {
                    return false;
                }
                logger.warn("Mod {} in version range {} was requested, was {}", (Object)modId, (Object)versionRange, (Object)version);
                return true;
            }
            return true;
        };
    }

    public boolean classNotExists(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }
}

